---
generated_at: 2026-01-22 12:10:00
metrics:
  claims_total: 16
  claims_with_evidence: 14
  claims_without_evidence: 2
confidence_derived: 0.88
---

# 根拠レポート：223-データベース診断画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.88**
  - 根拠あり：14 / 16、根拠なし：2
- 優先レビュー（高）
  1. **Vue.jsコンポーネントの実装詳細**：フロントエンド実装の確認
  2. **バックグラウンドワーカーの詳細実装**：ワーカーファイルの存在確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/controllers/admin/database_diagnostics_controller.rb`（行1-65）
- E-02: `app/views/admin/database_diagnostics/index.html.haml`（行1-17）
- E-03: `config/routes/admin.rb`（行124-131）
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`（行224）
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（行280）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLは/admin/database_diagnosticsである | E-03 (行124) | ○ |
| C-02 | feature_categoryはdatabaseである | E-01 (行5) | ○ |
| C-03 | read_admin_database_diagnostics権限が必要 | E-01 (行6-7) | ○ |
| C-04 | run_collation_checkアクションがある | E-01 (行24-26), E-03 (行126) | ○ |
| C-05 | run_schema_checkアクションがある | E-01 (行28-30), E-03 (行128) | ○ |
| C-06 | collation_check_resultsアクションがある | E-01 (行32-34), E-03 (行127) | ○ |
| C-07 | schema_check_resultsアクションがある | E-01 (行36-38), E-03 (行129) | ○ |
| C-08 | WORKER_CONFIGSでワーカー設定を管理 | E-01 (行9-18) | ○ |
| C-09 | ページタイトルは"Database Diagnostics" | E-02 (行1) | ○ |
| C-10 | 説明文は"Detect and resolve database issues." | E-02 (行8) | ○ |
| C-11 | #js-database-diagnostics要素が存在 | E-02 (行10) | ○ |
| C-12 | data属性でAPI URLが渡される | E-02 (行11-16) | ○ |
| C-13 | チェック結果はRails.cacheから読み取り | E-01 (行53-55) | ○ |
| C-14 | 機能No.143と関連 | E-05 (行280) | ○ |
| C-15 | Database::CollationCheckerWorkerが使用される | E-01 (行11: 参照あり) | △ |
| C-16 | Database::SchemaCheckerWorkerが使用される | E-01 (行15: 参照あり) | △ |

## 4) 不足情報（Unknown / Missing）
- C-15, C-16: ワーカーファイルの存在は確認できているが、実装詳細は未確認
  - 候補：`app/workers/database/collation_checker_worker.rb` / `app/workers/database/schema_checker_worker.rb`
- Vue.jsコンポーネントの実装
  - 候補：`app/assets/javascripts/admin/database_diagnostics/` または `ee/app/assets/javascripts/`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - バックエンドAPIは確認済み
- 1: 中リスク - フロントエンドVue.jsコンポーネントの詳細未確認
- 1: 中リスク - ワーカーの実装詳細未確認

## 6) レビュアーチェックリスト（最小）
- [ ] Database::CollationCheckerWorkerの存在と実装を確認
- [ ] Database::SchemaCheckerWorkerの存在と実装を確認
- [ ] Vue.jsコンポーネント（#js-database-diagnostics）の実装を確認
- [ ] キャッシュキー（COLLATION_CHECK_CACHE_KEY, SCHEMA_CHECK_CACHE_KEY）の定義場所を確認
