---
generated_at: 2026-01-22 12:15:00
metrics:
  claims_total: 20
  claims_with_evidence: 18
  claims_without_evidence: 2
confidence_derived: 0.90
---

# 根拠レポート：224-ユーザー一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：18 / 20、根拠なし：2
- 優先レビュー（高）
  1. **Vue.jsコンポーネントの実装詳細**：フロントエンド実装の確認
  2. **User.searchメソッドの詳細**：検索ロジックの確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/controllers/admin/users_controller.rb`（行1-475）
- E-02: `app/views/admin/users/index.html.haml`（行1-15）
- E-03: `app/views/admin/users/_tabs.html.haml`（行1-9）
- E-04: `app/views/admin/users/_users.html.haml`（行1-18）
- E-05: `config/routes/admin.rb`（行4-33）
- E-06: `app/models/user.rb`（行1-200, 抜粋）
- E-07: `docs/code-to-docs/画面一覧/画面一覧.csv`（行225）
- E-08: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（行281）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLは/admin/usersである | E-05 (行4) | ○ |
| C-02 | feature_categoryはuser_managementである | E-01 (行12) | ○ |
| C-03 | cohortsタブへのリダイレクトがある | E-01 (行17) | ○ |
| C-04 | filter_usersで基本フィルタリング | E-01 (行19, 465-467) | ○ |
| C-05 | search_queryによる検索がある | E-01 (行21-24) | ○ |
| C-06 | プライベートメール含む検索オプション | E-01 (行23: `with_private_emails: true`) | ○ |
| C-07 | sort_by_attributeでソート | E-01 (行29) | ○ |
| C-08 | デフォルトソートはname_asc | E-01 (行28: `sort_value_name`) | ○ |
| C-09 | ページネーション処理がある | E-01 (行30-31) | ○ |
| C-10 | paginate_without_count?による最適化 | E-01 (行324-328) | ○ |
| C-11 | PAGINATION_WITH_COUNT_LIMITは1000 | E-01 (行14) | ○ |
| C-12 | ページタイトルは"Users" | E-02 (行1) | ○ |
| C-13 | New userボタンがある | E-02 (行8-9) | ○ |
| C-14 | admin_all_resources権限でボタン表示 | E-02 (行5) | ○ |
| C-15 | タブにUsersとCohortsがある | E-03 (行5, 8) | ○ |
| C-16 | #js-admin-users-filter-appが存在 | E-04 (行11) | ○ |
| C-17 | #js-admin-users-appが存在 | E-04 (行15) | ○ |
| C-18 | 機能No.111と関連 | E-08 (行281) | ○ |
| C-19 | Vue.jsコンポーネントの詳細実装 | **根拠なし** | △ |
| C-20 | User.filter_itemsメソッドの詳細 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-19: Vue.jsコンポーネントの実装詳細
  - 候補：`app/assets/javascripts/admin/users/` / `ee/app/assets/javascripts/admin/`
- C-20: User.filter_itemsメソッドの詳細実装
  - 候補：`app/models/user.rb` の該当箇所、`app/models/concerns/` のモジュール

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - バックエンドロジックは確認済み
- 1: 中リスク - フロントエンドVue.jsコンポーネントの詳細未確認

## 6) レビュアーチェックリスト（最小）
- [ ] Vue.jsコンポーネント（#js-admin-users-app、#js-admin-users-filter-app）の実装を確認
- [ ] User.filter_itemsメソッドの利用可能なフィルター値を確認
- [ ] User.searchメソッドの検索対象フィールドを確認
- [ ] ページネーション時の総件数表示条件を確認
