---
generated_at: 2026-01-22 12:20:00
metrics:
  claims_total: 28
  claims_with_evidence: 26
  claims_without_evidence: 2
confidence_derived: 0.93
---

# 根拠レポート：225-ユーザー詳細

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：26 / 28、根拠なし：2
- 優先レビュー（高）
  1. **サービスクラスの詳細実装**：各種サービスクラスの存在確認
  2. **EE版追加フィールド**：EE固有機能の確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/controllers/admin/users_controller.rb`（行1-475）
- E-02: `app/views/admin/users/show.html.haml`（行1-209）
- E-03: `config/routes/admin.rb`（行4-33）
- E-04: `app/models/user.rb`（行1-200, 抜粋）
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv`（行226）
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（行282）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLは/admin/users/:idである | E-03 | ○ |
| C-02 | showアクションが存在 | E-01 (行34) | ○ |
| C-03 | blockアクションが存在 | E-01 (行116-130), E-03 (行17) | ○ |
| C-04 | unblockアクションが存在 | E-01 (行132-144), E-03 (行18) | ○ |
| C-05 | banアクションが存在 | E-01 (行146-155), E-03 (行19) | ○ |
| C-06 | unbanアクションが存在 | E-01 (行157-165), E-03 (行20) | ○ |
| C-07 | activateアクションが存在 | E-01 (行94-103), E-03 (行22) | ○ |
| C-08 | deactivateアクションが存在 | E-01 (行105-114), E-03 (行21) | ○ |
| C-09 | unlockアクションが存在 | E-01 (行167-173), E-03 (行23) | ○ |
| C-10 | confirmアクションが存在 | E-01 (行195-201), E-03 (行24) | ○ |
| C-11 | impersonateアクションが存在 | E-01 (行55-72), E-03 (行29) | ○ |
| C-12 | disable_two_factorアクションが存在 | E-01 (行203-212), E-03 (行30) | ○ |
| C-13 | trustアクションが存在 | E-01 (行175-183), E-03 (行26) | ○ |
| C-14 | untrustアクションが存在 | E-01 (行185-193), E-03 (行27) | ○ |
| C-15 | approveアクションが存在 | E-01 (行74-82), E-03 (行25) | ○ |
| C-16 | rejectアクションが存在 | E-01 (行84-92), E-03 (行28) | ○ |
| C-17 | ユーザー名表示がある | E-02 (行11, 34) | ○ |
| C-18 | メールアドレス表示がある | E-02 (行40-42) | ○ |
| C-19 | 2FA状態表示がある | E-02 (行84-93) | ○ |
| C-20 | サインイン情報表示がある | E-02 (行137-160) | ○ |
| C-21 | Users::BlockServiceが使用される | E-01 (行117) | ○ |
| C-22 | TwoFactor::DestroyServiceが使用される | E-01 (行204) | ○ |
| C-23 | なりすまし時にsession[:impersonator_id]を設定 | E-01 (行57) | ○ |
| C-24 | warden.set_userでユーザー切替 | E-01 (行59) | ○ |
| C-25 | LDAPユーザーのアンブロック制限 | E-01 (行133-134) | ○ |
| C-26 | 機能No.111と関連 | E-06 (行282) | ○ |
| C-27 | サービスクラスの詳細実装 | **根拠なし** | △ |
| C-28 | EE版追加フィールド | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-27: 各種サービスクラスの詳細実装
  - 候補：`app/services/users/block_service.rb` / `app/services/two_factor/destroy_service.rb`
- C-28: EE版固有の表示項目
  - 候補：`ee/app/views/admin/users/` / `render_if_exists`で呼び出されるパーシャル

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コントローラロジックは確認済み
- 0: 低リスク - ビューの主要項目は確認済み
- 1: 中リスク - サービスクラスの詳細未確認

## 6) レビュアーチェックリスト（最小）
- [ ] Users::BlockServiceの実装を確認
- [ ] Users::UnblockServiceの実装を確認
- [ ] TwoFactor::DestroyServiceの実装を確認
- [ ] なりすまし機能の権限チェック（can_impersonate_user）の詳細を確認
- [ ] EE版追加フィールド（render_if_exists呼び出し）の内容を確認
