---
generated_at: 2026-01-22 12:35:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：228-アイデンティティ一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **_identity.html.hamlパーシャル**：アイデンティティ行の詳細表示内容
  2. **RepairLdapBlockedServiceの詳細**：サービスクラスの実装確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/controllers/admin/identities_controller.rb`（行1-73）
- E-02: `app/views/admin/identities/index.html.haml`（行1-21）
- E-03: `app/models/identity.rb`（行1-60）
- E-04: `config/routes/admin.rb`（行6）
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv`（行229）
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（行285）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLは/admin/users/:user_id/identitiesである | E-04 (行6) | ○ |
| C-02 | feature_categoryはsystem_accessである | E-01 (行7) | ○ |
| C-03 | indexアクションで一覧取得 | E-01 (行24-33) | ○ |
| C-04 | @identities = @user.identitiesで関連取得 | E-01 (行25) | ○ |
| C-05 | can_impersonate設定がある | E-01 (行26) | ○ |
| C-06 | destroyアクションが存在 | E-01 (行47-56) | ○ |
| C-07 | RepairLdapBlockedServiceを実行 | E-01 (行49) | ○ |
| C-08 | 削除成功メッセージ | E-01 (行51-52) | ○ |
| C-09 | 削除失敗メッセージ | E-01 (行54) | ○ |
| C-10 | テーブルヘッダー（Provider等）がある | E-02 (行10-15) | ○ |
| C-11 | identity_cells_to_render?で表示判定 | E-02 (行6) | ○ |
| C-12 | 空状態コンポーネントがある | E-02 (行19-21) | ○ |
| C-13 | 空状態メッセージ"This user has no identities" | E-02 (行20) | ○ |
| C-14 | scim_identities_collectionのEE対応 | E-02 (行16) | ○ |
| C-15 | Identityモデルにprovider、extern_uidがある | E-03 (行9-14) | ○ |
| C-16 | 機能No.111と関連 | E-06 (行285) | ○ |
| C-17 | _identity.html.hamlパーシャルの詳細 | **根拠なし** | △ |
| C-18 | RepairLdapBlockedServiceの詳細実装 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-17: _identity.html.hamlパーシャルの詳細内容
  - 候補：`app/views/admin/identities/_identity.html.haml`
- C-18: RepairLdapBlockedServiceの詳細実装
  - 候補：`app/services/users/repair_ldap_blocked_service.rb`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コントローラロジックは確認済み
- 1: 中リスク - パーシャルの詳細未確認

## 6) レビュアーチェックリスト（最小）
- [ ] _identity.html.hamlパーシャルの内容を確認
- [ ] RepairLdapBlockedServiceの実装を確認
- [ ] EE版scim_identities_collectionの内容を確認
- [ ] identity_cells_to_render?ヘルパーの実装を確認
