---
generated_at: 2026-01-22 12:40:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：229-アイデンティティ新規作成

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - 特になし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/controllers/admin/identities_controller.rb`（行9-22, 70-72）
- E-02: `app/views/admin/identities/new.html.haml`（行1-7）
- E-03: `app/views/admin/identities/_form.html.haml`（行1-18）
- E-04: `config/routes/admin.rb`（行6）
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv`（行230）
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（行286）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLは/admin/users/:user_id/identities/newである | E-04 (行6) | ○ |
| C-02 | feature_categoryはsystem_accessである | E-01 (行7) | ○ |
| C-03 | newアクションでIdentity.newを生成 | E-01 (行9-11) | ○ |
| C-04 | createアクションでアイデンティティ作成 | E-01 (行13-22) | ○ |
| C-05 | @identity.user_id = user.idで紐付け | E-01 (行15) | ○ |
| C-06 | 保存成功時「User identity was successfully created.」 | E-01 (行18) | ○ |
| C-07 | 保存失敗時render :new | E-01 (行20) | ○ |
| C-08 | ページタイトルは「New identity」 | E-02 (行4) | ○ |
| C-09 | パンくずリストが設定される | E-02 (行1-3) | ○ |
| C-10 | PageHeadingComponentでヘッダー表示 | E-02 (行6) | ○ |
| C-11 | _formパーシャルをレンダリング | E-02 (行7) | ○ |
| C-12 | gitlab_ui_form_forでフォーム生成 | E-03 (行1) | ○ |
| C-13 | Gitlab::Auth::OAuth::Provider.providersからプロバイダ取得 | E-03 (行8) | ○ |
| C-14 | extern_uidフィールドが必須 | E-03 (行15: required: true) | ○ |
| C-15 | Save changesボタンがある | E-03 (行18) | ○ |
| C-16 | identity_paramsにprovider, extern_uid, saml_provider_idが含まれる | E-01 (行70-72) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張に根拠あり
- 0: 低リスク - コントローラ・ビューの対応が明確

## 6) レビュアーチェックリスト（最小）
- [ ] EE版のprovider_idパーシャルの内容を確認（render_if_exists）
- [ ] Identityモデルのバリデーションルールを確認
- [ ] Gitlab::Auth::OAuth::Providerのプロバイダ一覧を確認
