---
generated_at: 2026-01-22 12:45:00
metrics:
  claims_total: 17
  claims_with_evidence: 17
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：230-アイデンティティ編集

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：17 / 17、根拠なし：0
- 優先レビュー（高）
  - 特になし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/controllers/admin/identities_controller.rb`（行35-45, 66-68, 70-72）
- E-02: `app/views/admin/identities/edit.html.haml`（行1-7）
- E-03: `app/views/admin/identities/_form.html.haml`（行1-18）
- E-04: `config/routes/admin.rb`（行6）
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv`（行231）
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（行287）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLは/admin/users/:user_id/identities/:id/editである | E-04 (行6) | ○ |
| C-02 | feature_categoryはsystem_accessである | E-01 (行7) | ○ |
| C-03 | editアクションは空（before_actionで設定） | E-01 (行35) | ○ |
| C-04 | before_action: identityでアイデンティティ取得 | E-01 (行5, 66-68) | ○ |
| C-05 | updateアクションでアイデンティティ更新 | E-01 (行37-45) | ○ |
| C-06 | @identity.update(identity_params)で更新 | E-01 (行38) | ○ |
| C-07 | 成功時RepairLdapBlockedServiceを実行 | E-01 (行39) | ○ |
| C-08 | 更新成功時「User identity was successfully updated.」 | E-01 (行41) | ○ |
| C-09 | 更新失敗時render :edit | E-01 (行43) | ○ |
| C-10 | ページタイトルにプロバイダ名を含む | E-02 (行4) | ○ |
| C-11 | パンくずリストが設定される | E-02 (行1-3) | ○ |
| C-12 | ヘッダーは「Edit identity for {ユーザー名}」 | E-02 (行6) | ○ |
| C-13 | _formパーシャルをレンダリング | E-02 (行7) | ○ |
| C-14 | gitlab_ui_form_forでフォーム生成 | E-03 (行1) | ○ |
| C-15 | Gitlab::Auth::OAuth::Provider.providersからプロバイダ取得 | E-03 (行8) | ○ |
| C-16 | extern_uidフィールドが必須 | E-03 (行15: required: true) | ○ |
| C-17 | identity_paramsにprovider, extern_uid, saml_provider_idが含まれる | E-01 (行70-72) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張に根拠あり
- 0: 低リスク - コントローラ・ビューの対応が明確

## 6) レビュアーチェックリスト（最小）
- [ ] Users::RepairLdapBlockedServiceの実装を確認
- [ ] EE版のprovider_idパーシャルの内容を確認（render_if_exists）
- [ ] Identityモデルのバリデーションルールを確認
- [ ] 既存値がフォームに正しく表示されるか確認
