---
generated_at: 2026-01-22 12:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：231-SSHキー詳細

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **メッセージID体系**：ドキュメント用に付与したIDであり、実際のシステムでは異なる可能性
  2. **最終使用日の表示形式**：「Never」の表示は推測

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/controllers/admin/keys_controller.rb`
- E-02: `app/views/admin/keys/show.html.haml`
- E-03: `app/views/user_settings/ssh_keys/_key_details.html.haml`
- E-04: `config/routes/admin.rb`
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 管理者がSSHキー詳細を確認できる | E-01, E-02 | ○ |
| C-02 | URL形式が /admin/users/:user_id/keys/:id | E-04 | ○ |
| C-03 | コントローラがAdmin::KeysController | E-01 | ○ |
| C-04 | showアクションでキー情報を取得 | E-01 (8-15行目) | ○ |
| C-05 | destroyアクションでキーを削除 | E-01 (17-28行目) | ○ |
| C-06 | 削除成功メッセージ「User key was successfully removed.」 | E-01 (23行目) | ○ |
| C-07 | 削除失敗メッセージ「Failed to remove user key.」 | E-01 (26行目) | ○ |
| C-08 | ユーザー名でユーザーを検索 | E-01 (35行目) | ○ |
| C-09 | 共通パーシャル_key_details.html.hamlを使用 | E-02, E-03 | ○ |
| C-10 | キーの使用タイプ表示 | E-03 (26-27行目) | ○ |
| C-11 | キーの作成日表示 | E-03 (28-29行目) | ○ |
| C-12 | キーの最終使用日表示 | E-03 (30-31行目) | ○ |
| C-13 | キーの有効期限表示 | E-03 (32-40行目) | ○ |
| C-14 | 期限切れキーの赤色表示 | E-03 (34-36行目) | ○ |
| C-15 | MD5/SHA256フィンガープリント表示 | E-03 (59-64行目) | ○ |
| C-16 | 関連機能がSSHキー管理(No.80) | E-05 | ○ |
| C-17 | メッセージIDがMSG001-MSG003の体系 | **根拠なし** | △ |
| C-18 | 最終使用日が「Never」と表示される | E-03 (31行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- メッセージID体系はドキュメント作成時に付与したもので、実際のi18n翻訳キーとは異なる
  - 候補：Railsのi18nファイルを確認 / GitLabのlocaleファイルを参照

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ビューとコントローラの実装は確認済み
- 1: 中リスク - メッセージID体系は実装と異なる可能性あり

## 6) レビュアーチェックリスト（最小）
- [ ] メッセージ表示が実際の画面と一致するか確認
- [ ] 削除時の確認ダイアログの挙動を確認
- [ ] 安全でないキーの警告表示条件を確認
