---
generated_at: 2026-01-22 12:00:00
metrics:
  claims_total: 20
  claims_with_evidence: 18
  claims_without_evidence: 2
confidence_derived: 0.90
---

# 根拠レポート：233-グループ詳細

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：18 / 20、根拠なし：2
- 優先レビュー（高）
  1. **LDAP連携機能**：EE版の機能のため詳細未確認
  2. **共有Runner設定**：EE版パーシャルのため未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/controllers/admin/groups_controller.rb`
- E-02: `app/views/admin/groups/show.html.haml`
- E-03: `config/routes/admin.rb`
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URL形式が /admin/groups/:id | E-03 (77行目) | ○ |
| C-02 | コントローラがAdmin::GroupsController#show | E-01 (13-24行目) | ○ |
| C-03 | with_statisticsスコープでグループ取得 | E-01 (18行目) | ○ |
| C-04 | メンバーをaccess_level DESCでソート | E-01 (20行目) | ○ |
| C-05 | AccessRequestsFinderでリクエスト取得 | E-01 (21-22行目) | ○ |
| C-06 | プロジェクトをwith_statisticsで取得 | E-01 (23行目) | ○ |
| C-07 | Editボタンがcan_admin_all_resources?で制御 | E-02 (10行目) | ○ |
| C-08 | グループ名表示 | E-02 (25行目) | ○ |
| C-09 | グループパス表示 | E-02 (29行目) | ○ |
| C-10 | グループ説明表示 | E-02 (33行目) | ○ |
| C-11 | 可視性レベル表示 | E-02 (37行目) | ○ |
| C-12 | 作成日表示 | E-02 (41行目) | ○ |
| C-13 | グループID表示 | E-02 (45行目) | ○ |
| C-14 | ストレージ使用量表示 | E-02 (48行目) | ○ |
| C-15 | Git LFSステータス表示 | E-02 (52-53行目) | ○ |
| C-16 | プロジェクト一覧セクション | E-02 (58-75行目) | ○ |
| C-17 | 共有プロジェクトセクション | E-02 (77-91行目) | ○ |
| C-18 | グループメンバーセクション | E-02 (98-116行目) | ○ |
| C-19 | LDAP連携機能（EE版） | **根拠なし** | △ |
| C-20 | 共有Runner設定（EE版） | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- Enterprise Edition専用機能の詳細
  - 候補：`ee/app/views/admin/groups/` ディレクトリ確認
- render_if_existsで参照されるEE版パーシャル
  - 候補：`ee/app/views/namespaces/`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - CE版の主要機能は確認済み
- 1: 中リスク - EE版固有機能は別途確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] LDAP連携セクションの表示条件を確認（EE版）
- [ ] 共有Runner設定の表示条件を確認（EE版）
- [ ] ストレージ表示のフォーマットを確認
- [ ] メンバー一覧のページネーション動作を確認
