---
generated_at: 2026-01-22 12:00:00
metrics:
  claims_total: 22
  claims_with_evidence: 20
  claims_without_evidence: 2
confidence_derived: 0.91
---

# 根拠レポート：234-グループ新規作成

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.91**
  - 根拠あり：20 / 22、根拠なし：2
- 優先レビュー（高）
  1. **バリデーションルール詳細**：Groupモデルのバリデーション詳細は別途確認が必要
  2. **EE版固有機能**：ストレージ制限等のEE版機能は未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/controllers/admin/groups_controller.rb`
- E-02: `app/views/admin/groups/new.html.haml`
- E-03: `app/views/admin/groups/_form.html.haml`
- E-04: `config/routes/admin.rb`
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URL形式が /admin/groups/new | E-04 (60行目) | ○ |
| C-02 | newアクションでGroup.newを初期化 | E-01 (27-30行目) | ○ |
| C-03 | admin_noteをビルド | E-01 (29行目) | ○ |
| C-04 | createアクションでGroups::CreateServiceを使用 | E-01 (37-38行目) | ○ |
| C-05 | organization_idを自動設定 | E-01 (38行目) | ○ |
| C-06 | 成功メッセージの表示 | E-01 (43行目) | ○ |
| C-07 | 失敗時にnewを再レンダリング | E-01 (45行目) | ○ |
| C-08 | 許可されるパラメータ一覧 | E-01 (89-108行目) | ○ |
| C-09 | _formパーシャルを使用 | E-02 (6行目) | ○ |
| C-10 | default_group_visibilityを使用 | E-02 (6行目) | ○ |
| C-11 | 命名・可視性セクション | E-03 (4-15行目) | ○ |
| C-12 | 権限・機能セクション | E-03 (16-25行目) | ○ |
| C-13 | 管理者メモセクション | E-03 (27-29行目) | ○ |
| C-14 | Create groupボタン | E-03 (36行目) | ○ |
| C-15 | Cancelボタン | E-03 (37-38行目) | ○ |
| C-16 | Tipsアラート表示 | E-03 (32-34行目) | ○ |
| C-17 | グループ名フィールド | E-03 (9行目) | ○ |
| C-18 | グループパスフィールド | E-03 (9行目) | ○ |
| C-19 | 可視性レベル設定 | E-03 (14行目) | ○ |
| C-20 | Runner登録設定 | E-01 (97行目) | ○ |
| C-21 | バリデーションルール詳細 | **根拠なし** | △ |
| C-22 | EE版固有機能 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- Groupモデルのバリデーション詳細
  - 候補：`app/models/group.rb` / `app/models/namespace.rb`
- EE版固有の入力フィールド
  - 候補：`ee/app/views/admin/groups/` / `ee/app/views/shared/`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要なフォームフィールドと処理フローは確認済み
- 1: 中リスク - EE版固有機能とバリデーション詳細は別途確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] グループ名の最大文字数制限を確認
- [ ] パスの予約語リストを確認
- [ ] EE版固有のフィールド（ストレージ制限等）を確認
- [ ] デフォルトの可視性レベル設定を確認
