---
generated_at: 2026-01-22 12:00:00
metrics:
  claims_total: 20
  claims_with_evidence: 18
  claims_without_evidence: 2
confidence_derived: 0.90
---

# 根拠レポート：235-グループ編集

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：18 / 20、根拠なし：2
- 優先レビュー（高）
  1. **可視性変更時の制約**：子グループ・プロジェクトとの整合性チェックの詳細
  2. **パス変更時の影響**：ルート変更の詳細な動作

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/controllers/admin/groups_controller.rb`
- E-02: `app/views/admin/groups/edit.html.haml`
- E-03: `app/views/admin/groups/_form.html.haml`
- E-04: `config/routes/admin.rb`
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URL形式が /admin/groups/:id/edit | E-04 (76行目) | ○ |
| C-02 | editアクションで管理者メモをビルド | E-01 (32-34行目) | ○ |
| C-03 | updateアクションでGroups::UpdateServiceを使用 | E-01 (52行目) | ○ |
| C-04 | Runner登録無効時にトークンリセット | E-01 (53-55行目) | ○ |
| C-05 | 成功時にグループ詳細にリダイレクト | E-01 (57行目) | ○ |
| C-06 | 成功メッセージ「Group was successfully updated.」 | E-01 (57行目) | ○ |
| C-07 | 失敗時にeditを再レンダリング | E-01 (59行目) | ○ |
| C-08 | パンくずにグループ一覧、グループ名を追加 | E-02 (1-3行目) | ○ |
| C-09 | ページタイトルが「Edit」 | E-02 (4行目) | ○ |
| C-10 | _formパーシャルを使用 | E-02 (7行目) | ○ |
| C-11 | 現在の可視性レベルを渡す | E-02 (7行目) | ○ |
| C-12 | Save changesボタン | E-03 (42行目) | ○ |
| C-13 | Cancelボタンがグループ詳細にリンク | E-03 (43-44行目) | ○ |
| C-14 | 許可されるパラメータ一覧 | E-01 (89-108行目) | ○ |
| C-15 | enabled_git_access_protocolパラメータ | E-01 (101行目) | ○ |
| C-16 | グループ管理(No.112)が関連機能 | E-05 | ○ |
| C-17 | グループ編集(No.10)が関連機能 | E-05 | ○ |
| C-18 | before_actionでgroupをセット | E-01 (6行目) | ○ |
| C-19 | 可視性変更時の子グループ整合性チェック | **根拠なし** | △ |
| C-20 | パス変更時のルート自動更新 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- Groups::UpdateServiceの詳細な実装
  - 候補：`app/services/groups/update_service.rb`
- 可視性変更時のバリデーションロジック
  - 候補：`app/models/group.rb` のバリデーション

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コントローラとビューの主要機能は確認済み
- 1: 中リスク - UpdateServiceの詳細動作は別途確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] Groups::UpdateServiceの実装を確認
- [ ] パス変更時のリダイレクト処理を確認
- [ ] 可視性変更の制約条件を確認
- [ ] Runner登録トークンリセットの動作を確認
