---
generated_at: 2026-01-22 12:00:00
metrics:
  claims_total: 24
  claims_with_evidence: 22
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：237-プロジェクト詳細

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：22 / 24、根拠なし：2
- 優先レビュー（高）
  1. **Geoステータス機能（EE）**：EE版機能のため詳細未確認
  2. **共有Runner設定（EE）**：EE版機能のため詳細未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/controllers/admin/projects_controller.rb`
- E-02: `app/views/admin/projects/show.html.haml`
- E-03: `config/routes/admin.rb`
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URL形式が /admin/:namespace_id/:project_id | E-03 (147-165行目) | ○ |
| C-02 | showアクションでプロジェクト取得 | E-01 (13-23行目) | ○ |
| C-03 | グループメンバーをaccess_level DESCでソート | E-01 (16行目) | ○ |
| C-04 | AccessRequestsFinderでリクエスト取得 | E-01 (21-22行目) | ○ |
| C-05 | transferアクションでTransferServiceを使用 | E-01 (38行目) | ○ |
| C-06 | repository_checkアクションでワーカーをキュー | E-01 (65行目) | ○ |
| C-07 | 成功メッセージ「Repository check was triggered.」 | E-01 (69行目) | ○ |
| C-08 | Editボタンがcan_admin_all_resources?で制御 | E-02 (9行目) | ○ |
| C-09 | リポジトリチェック失敗時の警告バナー | E-02 (14-21行目) | ○ |
| C-10 | プロジェクト名表示 | E-02 (32行目) | ○ |
| C-11 | ネームスペース表示 | E-02 (37-40行目) | ○ |
| C-12 | オーナー表示 | E-02 (45-48行目) | ○ |
| C-13 | 作成者表示 | E-02 (54行目) | ○ |
| C-14 | HTTP/SSH URL表示 | E-02 (72-77行目) | ○ |
| C-15 | ストレージ名表示 | E-02 (83行目) | ○ |
| C-16 | 相対パス表示 | E-02 (91行目) | ○ |
| C-17 | 最終コミット表示 | E-02 (103行目) | ○ |
| C-18 | Git LFSステータス表示 | E-02 (109行目) | ○ |
| C-19 | アーカイブ状態表示 | E-02 (118-123行目) | ○ |
| C-20 | 移行セクション（Transfer） | E-02 (139-147行目) | ○ |
| C-21 | リポジトリチェックセクション | E-02 (149-165行目) | ○ |
| C-22 | メンバーセクション | E-02 (167-202行目) | ○ |
| C-23 | Geoステータスウィジェット（EE） | **根拠なし** | △ |
| C-24 | 共有Runner設定（EE） | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- Enterprise Edition専用機能の詳細
  - 候補：`ee/app/views/admin/projects/` ディレクトリ確認
- render_if_existsで参照されるEE版パーシャル
  - 候補：`ee/app/views/admin/projects/`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - CE版の主要機能は確認済み
- 1: 中リスク - EE版固有機能は別途確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] TransferServiceの詳細動作を確認
- [ ] リポジトリチェックワーカーの動作を確認
- [ ] Geo機能（EE）の表示条件を確認
- [ ] 共有Runner設定（EE）の表示条件を確認
