---
generated_at: 2026-01-22 12:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：238-プロジェクト編集

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **バリデーション詳細**：プロジェクト名の最大文字数などの詳細

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/controllers/admin/projects_controller.rb`
- E-02: `app/views/admin/projects/edit.html.haml`
- E-03: `app/views/admin/projects/_form.html.haml`
- E-04: `config/routes/admin.rb`
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URL形式が /admin/:namespace_id/:project_id/edit | E-04 (161行目) | ○ |
| C-02 | editアクションが空のメソッド | E-01 (47行目) | ○ |
| C-03 | updateアクションでProjects::UpdateServiceを使用 | E-01 (50行目) | ○ |
| C-04 | Runner登録無効時にトークンリセット | E-01 (53-55行目) | ○ |
| C-05 | 成功時にプロジェクト詳細にリダイレクト | E-01 (57行目) | ○ |
| C-06 | 成功メッセージのフォーマット | E-01 (58行目) | ○ |
| C-07 | 失敗時にeditを再レンダリング | E-01 (60行目) | ○ |
| C-08 | 許可されるパラメータが限定的 | E-01 (90-95行目) | ○ |
| C-09 | name, description, runner_registration_enabledのみ許可 | E-01 (91-94行目) | ○ |
| C-10 | パンくずにプロジェクト一覧、プロジェクト名を追加 | E-02 (1-3行目) | ○ |
| C-11 | ページタイトルが「Edit」 | E-02 (4行目) | ○ |
| C-12 | _formパーシャルを使用 | E-02 (7行目) | ○ |
| C-13 | 命名セクション | E-03 (2-17行目) | ○ |
| C-14 | プロジェクト名フィールド | E-03 (8-9行目) | ○ |
| C-15 | プロジェクトID（読取専用） | E-03 (11-13行目) | ○ |
| C-16 | Runner登録設定 | E-03 (28-31行目) | ○ |
| C-17 | システム設定でRunner登録が無効の場合の制御 | E-03 (27行目) | ○ |
| C-18 | バリデーション詳細（最大文字数等） | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- Projectモデルのバリデーション詳細
  - 候補：`app/models/project.rb` のバリデーション定義

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コントローラ、ビュー、フォームの実装は確認済み
- 0: 低リスク - 許可されるパラメータが明確に限定されている

## 6) レビュアーチェックリスト（最小）
- [ ] Projects::UpdateServiceの詳細動作を確認
- [ ] プロジェクト名のバリデーションルールを確認
- [ ] Runner登録トークンリセットの動作を確認
