---
generated_at: 2026-01-22 12:00:00
metrics:
  claims_total: 14
  claims_with_evidence: 12
  claims_without_evidence: 2
confidence_derived: 0.86
---

# 根拠レポート：239-組織一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.86**
  - 根拠あり：12 / 14、根拠なし：2
- 優先レビュー（高）
  1. **Vue.jsアプリの詳細実装**：フロントエンドのJSファイルは未確認
  2. **表示項目の詳細**：API/GraphQL仕様は未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/controllers/admin/organizations_controller.rb`
- E-02: `app/views/admin/organizations/index.html.haml`
- E-03: `config/routes/admin.rb`
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URL形式が /admin/organizations | E-03 (67行目) | ○ |
| C-02 | コントローラがAdmin::OrganizationsController | E-01 | ○ |
| C-03 | Vue.jsベースのSPAとして実装 | E-02 (3行目) | ○ |
| C-04 | admin_organizations_index_app_dataヘルパーを使用 | E-02 (3行目) | ○ |
| C-05 | ページタイトルが「Organizations」 | E-02 (1行目) | ○ |
| C-06 | フィーチャーフラグでアクセス制御 | E-01 (9, 17-19行目) | ○ |
| C-07 | ui_for_organizations_enabled?をチェック | E-01 (19行目) | ○ |
| C-08 | organization_switchingフィーチャーフラグをプッシュ | E-01 (11行目) | ○ |
| C-09 | indexアクションが空のメソッド | E-01 (14行目) | ○ |
| C-10 | OrganizationHelperをインクルード | E-01 (5行目) | ○ |
| C-11 | 組織管理(No.134)が関連機能 | E-04 | ○ |
| C-12 | フィーチャーフラグ無効時にaccess_denied! | E-01 (19行目) | ○ |
| C-13 | Vue.jsアプリの詳細な表示項目 | **根拠なし** | △ |
| C-14 | 検索・ページネーション機能の詳細 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- Vue.jsフロントエンドコンポーネントのソースコード未確認
  - 候補：`app/assets/javascripts/admin/organizations/`
- 組織一覧の表示項目はフロントエンドで定義されている可能性
  - 候補：GraphQLスキーマ / REST APIレスポンス仕様

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 基本的なルーティングとコントローラは確認済み
- 1: 中リスク - Vue.jsアプリの詳細実装は別途確認が必要
- 1: 中リスク - 組織機能は比較的新しく、仕様が変更される可能性

## 6) レビュアーチェックリスト（最小）
- [ ] Vue.jsアプリの実装ファイルを確認
- [ ] 組織一覧APIの仕様を確認
- [ ] フィーチャーフラグの有効化条件を確認
- [ ] 組織モデルの構造を確認
