---
generated_at: 2026-01-22 12:15:00
metrics:
  claims_total: 25
  claims_with_evidence: 23
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：24-プロジェクト詳細

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：23 / 25、根拠なし：2
- 優先レビュー（高）
  1. **サイドバー情報の詳細**：サイドバーパーシャルの確認が必要
  2. **GraphQL APIの具体的なクエリ**：path_last_commitクエリの詳細確認

## 2) 参照した情報（Evidence一覧）

- E-01: `app/views/projects/show.html.haml`
- E-02: `app/controllers/projects_controller.rb`
- E-03: `app/views/projects/_home_panel.html.haml`
- E-04: `app/views/projects/_files.html.haml`
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-06: `docs/code-to-docs/画面一覧/画面一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | showアクションの基本処理 | E-02 (172-199行目) | ○ |
| C-02 | repository_rootでルートref取得 | E-02 (601-606行目) | ○ |
| C-03 | インポート中チェックとリダイレクト | E-02 (176-179行目) | ○ |
| C-04 | 削除予定警告の表示 | E-02 (181-183行目) | ○ |
| C-05 | render_landing_pageでビュー分岐 | E-02 (431-450行目) | ○ |
| C-06 | no_repoビューの表示条件 | E-02 (435行目) | ○ |
| C-07 | missing_default_branchの503表示 | E-02 (436行目) | ○ |
| C-08 | empty_repoビューの表示 | E-02 (438行目) | ○ |
| C-09 | toggle_starアクション | E-02 (347-354行目) | ○ |
| C-10 | ATOMフィード対応 | E-01 (7行目) | ○ |
| C-11 | home_panelパーシャル表示 | E-01 (15行目) | ○ |
| C-12 | sidebarパーシャル表示 | E-01 (21行目) | ○ |
| C-13 | default_viewによる動的コンテンツ | E-01 (27-30行目) | ○ |
| C-14 | GraphQL path_last_commit呼び出し | E-01 (25行目) | ○ |
| C-15 | プロジェクト名表示 | E-03 (7-8行目) | ○ |
| C-16 | 可視性アイコン表示 | E-03 (9行目) | ○ |
| C-17 | カタログリソースバッジ表示 | E-03 (10-11行目) | ○ |
| C-18 | feature_category :groups_and_projects | E-02 (69-72行目) | ○ |
| C-19 | project_overviewイベントトラッキング | E-02 (432行目) | ○ |
| C-20 | 関連機能No.1（プロジェクト作成） | E-05 (34-36行目) | ○ |
| C-21 | カテゴリ「プロジェクト」 | E-06 (25行目) | ○ |
| C-22 | repository_file_tree_browserフィーチャーフラグ | E-04 (5行目) | ○ |
| C-23 | ファイルツリーのGraphQL呼び出し | E-04 (6行目) | ○ |
| C-24 | サイドバー情報の詳細構成 | **根拠なし** | △ |
| C-25 | GraphQL path_last_commitの詳細レスポンス | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- サイドバー（`_sidebar.html.haml`）の詳細構成
  - 候補：`app/views/projects/_sidebar.html.haml` / サイドバーVueコンポーネント
- GraphQL APIのpath_last_commitクエリの詳細
  - 候補：`app/graphql/queries/` / `app/assets/javascripts/repository/`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コントローラの基本処理、ルーティング
- 0: 低リスク - ビューの条件分岐
- 1: 中リスク - GraphQL APIの詳細仕様

## 6) レビュアーチェックリスト（最小）
- [ ] render_landing_pageの条件分岐が正しいか確認
- [ ] toggle_starの動作を確認
- [ ] サイドバーの表示項目を確認
- [ ] GraphQL path_last_commitのレスポンス形式を確認
- [ ] フィーチャーフラグの影響範囲を確認
