---
generated_at: 2026-01-22 12:00:00
metrics:
  claims_total: 22
  claims_with_evidence: 20
  claims_without_evidence: 2
confidence_derived: 0.91
---

# 根拠レポート：240-トピック一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.91**
  - 根拠あり：20 / 22、根拠なし：2
- 優先レビュー（高）
  1. **TopicsFinderの詳細実装**：検索ロジックの詳細は未確認
  2. **Topics::MergeServiceの詳細実装**：マージロジックの詳細は未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/controllers/admin/topics_controller.rb`
- E-02: `app/views/admin/topics/index.html.haml`
- E-03: `app/views/admin/topics/_topic.html.haml`
- E-04: `config/routes/admin.rb`
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URL形式が /admin/topics | E-04 (84-89行目) | ○ |
| C-02 | indexアクションでTopicsFinderを使用 | E-01 (12-14行目) | ○ |
| C-03 | organization_idでフィルタリング | E-01 (14行目, 86-88行目) | ○ |
| C-04 | ページネーションにwithout_countを使用 | E-01 (15行目) | ○ |
| C-05 | destroyアクションでtopic.destroy! | E-01 (44行目) | ○ |
| C-06 | 削除成功メッセージのフォーマット | E-01 (47-48行目) | ○ |
| C-07 | mergeアクションでTopics::MergeServiceを使用 | E-01 (55行目) | ○ |
| C-08 | マージ失敗時に400 bad_requestを返す | E-01 (56行目) | ○ |
| C-09 | マージ成功メッセージのフォーマット | E-01 (58-59行目) | ○ |
| C-10 | 空のステート表示条件 | E-02 (7-8行目) | ○ |
| C-11 | ページタイトルが「Topics」 | E-02 (1行目) | ○ |
| C-12 | イベントトラッキングが設定されている | E-02 (10行目) | ○ |
| C-13 | New topicボタン | E-02 (13-14行目) | ○ |
| C-14 | マージUIのdata属性 | E-02 (12行目) | ○ |
| C-15 | 検索フォーム | E-02 (16-21行目) | ○ |
| C-16 | 検索結果が空の場合の表示 | E-02 (23-24行目) | ○ |
| C-17 | _topicパーシャルでコレクションレンダリング | E-02 (27行目) | ○ |
| C-18 | トピック名/タイトルの表示とリンク | E-03 (9行目) | ○ |
| C-19 | プロジェクト数の表示 | E-03 (15-17行目) | ○ |
| C-20 | 編集・削除ボタン | E-03 (20-21行目) | ○ |
| C-21 | TopicsFinderの検索ロジック詳細 | **根拠なし** | △ |
| C-22 | Topics::MergeServiceのマージロジック詳細 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- TopicsFinderの詳細な検索ロジック
  - 候補：`app/finders/projects/topics_finder.rb`
- Topics::MergeServiceのマージ処理詳細
  - 候補：`app/services/topics/merge_service.rb`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コントローラとビューの主要機能は確認済み
- 1: 中リスク - ファインダーとサービスの詳細は別途確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] TopicsFinderの検索ロジックを確認
- [ ] Topics::MergeServiceのマージ処理を確認
- [ ] トピック削除時の関連データ（project_topics）の処理を確認
- [ ] 空のステート画面のデザインを確認
