---
generated_at: 2026-01-22 12:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：241-トピック新規作成

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **メッセージ仕様の一部**：フロントエンドバリデーションメッセージの正確性

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/controllers/admin/topics_controller.rb` - コントローラ実装
- E-02: `app/models/projects/topic.rb` - モデル定義、バリデーション
- E-03: `app/views/admin/topics/new.html.haml` - 新規作成画面ビュー
- E-04: `app/views/admin/topics/_form.html.haml` - フォームパーシャル
- E-05: `config/routes/admin.rb` - ルーティング定義
- E-06: `app/finders/projects/topics_finder.rb` - ファインダー
- E-07: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧
- E-08: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面URL `/admin/topics/new` | E-05 (84行目) | ○ |
| C-02 | 管理者権限が必要 | E-01 (Admin::ApplicationController継承) | ○ |
| C-03 | nameフィールドは必須、255文字以内 | E-02 (15行目) | ○ |
| C-04 | titleフィールドは必須、255文字以内 | E-02 (26行目) | ○ |
| C-05 | descriptionは1024文字以内 | E-02 (16, 27行目) | ○ |
| C-06 | nameはASCII文字のみ許可 | E-02 (97-99行目) | ○ |
| C-07 | nameに改行禁止 | E-02 (93-96行目) | ○ |
| C-08 | organization_idが自動設定される | E-01 (70行目) | ○ |
| C-09 | 成功時のメッセージ形式 | E-01 (28-29行目) | ○ |
| C-10 | createアクションでTopic.new(topic_params)使用 | E-01 (25行目) | ○ |
| C-11 | 保存成功時にadmin_topics_pathへリダイレクト | E-01 (28行目) | ○ |
| C-12 | 保存失敗時にnewテンプレート再表示 | E-01 (31行目) | ○ |
| C-13 | Markdownプレビュー機能あり | E-04 (21-30行目) | ○ |
| C-14 | アバターアップロード機能あり | E-04 (33-39行目) | ○ |
| C-15 | フォームにname, title, description, avatarフィールドあり | E-04, E-01 (73-79行目) | ○ |
| C-16 | キャンセルボタンでトピック一覧へ遷移 | E-04 (44-45, 48-49行目) | ○ |
| C-17 | nameの一意性チェック（組織内） | E-02 (17行目) | ○ |
| C-18 | フロントエンドのバリデーションメッセージ表示 | E-04 (8-10, 16-17行目) | △ |

## 4) 不足情報（Unknown / Missing）
- C-18: フォームのHTML属性でrequiredとtitleが設定されているが、実際のブラウザ表示メッセージはブラウザ依存の可能性あり
  - 候補：ブラウザ実行テスト / フロントエンドテスト仕様

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全体的にコードと設計書の整合性が高い
- 1: 中リスク - フロントエンドのバリデーションメッセージ表示は実機確認推奨

## 6) レビュアーチェックリスト（最小）
- [ ] nameフィールドのバリデーションルール（ASCII、改行禁止）が正しく動作するか確認
- [ ] Markdownプレビュー機能が正常に動作するか確認
- [ ] アバターアップロード機能の動作確認
- [ ] organization_idが正しく設定されるか確認
