---
generated_at: 2026-01-22 12:10:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：243-アプリケーション一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/admin/applications_controller.rb` - コントローラ実装
- E-02: `app/models/authn/oauth_application.rb` - モデル定義
- E-03: `app/finders/applications_finder.rb` - ファインダー実装
- E-04: `app/views/admin/applications/index.html.haml` - 一覧画面ビュー
- E-05: `config/routes/admin.rb` - ルーティング定義
- E-06: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧
- E-07: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面URL `/admin/applications` | E-05 (56行目) | ○ |
| C-02 | ApplicationsFinder.new.executeで取得 | E-01 (12行目) | ○ |
| C-03 | owner_id: nilでインスタンスレベルをフィルタ | E-03 (11行目) | ○ |
| C-04 | keyset_paginateでページネーション | E-01 (13行目), E-04 (52行目) | ○ |
| C-05 | 総件数を別途取得 | E-01 (14行目) | ○ |
| C-06 | 空状態でEmptyStateComponent表示 | E-04 (9-16行目) | ○ |
| C-07 | CrudComponentでテーブル表示 | E-04 (19-52行目) | ○ |
| C-08 | Name, Callback URL, Trusted, Confidential, Actions列 | E-04 (35-50行目) | ○ |
| C-09 | 名前クリックで詳細画面へ遷移 | E-04 (43行目) | ○ |
| C-10 | 編集アイコンで編集画面へ遷移 | E-04 (49行目) | ○ |
| C-11 | 削除アイコンでモーダル表示 | E-04 (50行目, 54行目) | ○ |
| C-12 | 新規追加ボタンで新規作成画面へ | E-04 (3, 28-29行目) | ○ |
| C-13 | destroyアクションで削除処理 | E-01 (56-58行目) | ○ |
| C-14 | 削除成功メッセージ表示 | E-01 (58行目) | ○ |
| C-15 | ページタイトル「Instance OAuth applications」 | E-04 (1行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張に根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] Keyset Paginationが正しく動作するか確認
- [ ] 削除確認モーダルが表示されるか確認
- [ ] 空状態表示が正しくレンダリングされるか確認
- [ ] Trusted/Confidentialの表示が正しいか確認
