---
generated_at: 2026-01-22 12:15:00
metrics:
  claims_total: 14
  claims_with_evidence: 13
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：244-アプリケーション詳細

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：13 / 14、根拠なし：1
- 優先レビュー（高）
  1. **共有パーシャルの実装詳細**：`shared/doorkeeper/applications/_show.html.haml`の確認

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/admin/applications_controller.rb` - コントローラ実装
- E-02: `app/models/authn/oauth_application.rb` - モデル定義
- E-03: `app/views/admin/applications/show.html.haml` - 詳細画面ビュー
- E-04: `config/routes/admin.rb` - ルーティング定義
- E-05: `app/finders/applications_finder.rb` - ファインダー
- E-06: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧
- E-07: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面URL `/admin/applications/:id` | E-04 (56行目) | ○ |
| C-02 | before_action :set_applicationでロード | E-01 (6行目) | ○ |
| C-03 | ApplicationsFinderでid検索 | E-01 (72行目), E-05 (17-20行目) | ○ |
| C-04 | showアクションは空メソッド | E-01 (17行目) | ○ |
| C-05 | 共有パーシャル使用 | E-03 (6行目) | ○ |
| C-06 | show_trusted_row: trueで管理者用表示 | E-03 (11行目) | ○ |
| C-07 | renewアクションでシークレット再生成 | E-01 (46-54行目) | ○ |
| C-08 | renew_secretメソッド呼び出し | E-01 (47行目) | ○ |
| C-09 | 成功時にJSONでシークレット返却 | E-01 (50行目) | ○ |
| C-10 | 失敗時にエラー返却 | E-01 (52行目) | ○ |
| C-11 | edit_path, delete_path, renew_path設定 | E-03 (7-10行目) | ○ |
| C-12 | destroyアクションで削除 | E-01 (56-58行目) | ○ |
| C-13 | ページタイトル形式 | E-03 (4行目) | ○ |
| C-14 | 共有パーシャルの詳細表示内容 | 共有パーシャル未読込 | △ |

## 4) 不足情報（Unknown / Missing）
- C-14: `app/views/shared/doorkeeper/applications/_show.html.haml`の実装詳細
  - 候補：共有パーシャルファイルの確認

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コントローラとビューの主要処理は確認済み
- 1: 中リスク - 共有パーシャルの詳細実装は未確認

## 6) レビュアーチェックリスト（最小）
- [ ] シークレット再生成機能の動作確認
- [ ] 共有パーシャルで表示される項目の確認
- [ ] Trusted行が正しく表示されるか確認
- [ ] 削除機能の動作確認
