---
generated_at: 2026-01-22 12:20:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：245-アプリケーション新規作成

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/admin/applications_controller.rb` - コントローラ実装
- E-02: `app/models/authn/oauth_application.rb` - モデル定義
- E-03: `app/services/applications/create_service.rb` - 作成サービス
- E-04: `app/views/admin/applications/new.html.haml` - 新規作成画面ビュー
- E-05: `app/views/admin/applications/_form.html.haml` - フォームパーシャル
- E-06: `config/routes/admin.rb` - ルーティング定義
- E-07: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧
- E-08: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面URL `/admin/applications/new` | E-06 (56行目) | ○ |
| C-02 | before_action :load_scopesでスコープロード | E-01 (7行目) | ○ |
| C-03 | newアクションでOauthApplication.new | E-01 (20行目) | ○ |
| C-04 | createアクションでCreateService使用 | E-01 (26行目) | ○ |
| C-05 | スコープ必須チェック | E-03 (27-31行目) | ○ |
| C-06 | 成功時に@created = true設定 | E-01 (31行目) | ○ |
| C-07 | 成功時にshowテンプレートレンダリング | E-01 (32行目) | ○ |
| C-08 | 失敗時にnewテンプレートレンダリング | E-01 (34行目) | ○ |
| C-09 | owner = nilでインスタンスレベル | E-01 (81行目) | ○ |
| C-10 | organization = Current.organization | E-01 (82行目) | ○ |
| C-11 | フォームにname, redirect_uri, trusted, confidential, scopes | E-05 | ○ |
| C-12 | Trustedチェックボックスあり | E-05 (18-21行目) | ○ |
| C-13 | Confidentialチェックボックスあり | E-05 (23-26行目) | ○ |
| C-14 | スコープ選択フォームあり | E-05 (28-31行目) | ○ |
| C-15 | キャンセルボタンで一覧へ遷移 | E-05 (35行目) | ○ |
| C-16 | ページタイトル「Add new application」 | E-04 (3行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張に根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] スコープ選択が正しく動作するか確認
- [ ] Trusted/Confidentialオプションの説明が適切か確認
- [ ] 作成成功時にシークレットが表示されるか確認
- [ ] バリデーションエラー時の表示確認
