---
generated_at: 2026-01-22 12:25:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：246-アプリケーション編集

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/admin/applications_controller.rb` - コントローラ実装
- E-02: `app/models/authn/oauth_application.rb` - モデル定義
- E-03: `app/views/admin/applications/edit.html.haml` - 編集画面ビュー
- E-04: `app/views/admin/applications/_form.html.haml` - フォームパーシャル
- E-05: `config/routes/admin.rb` - ルーティング定義
- E-06: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧
- E-07: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面URL `/admin/applications/:id/edit` | E-05 (56行目) | ○ |
| C-02 | before_action :set_applicationでロード | E-01 (6行目) | ○ |
| C-03 | before_action :load_scopesでスコープロード | E-01 (7行目) | ○ |
| C-04 | editアクションは空メソッド | E-01 (23行目) | ○ |
| C-05 | updateアクションで@application.update | E-01 (39行目) | ○ |
| C-06 | 成功時にadmin_application_pathへリダイレクト | E-01 (40行目) | ○ |
| C-07 | 失敗時にeditテンプレートレンダリング | E-01 (42行目) | ○ |
| C-08 | 成功メッセージ表示 | E-01 (40行目) | ○ |
| C-09 | Web IDE警告コールアウト表示 | E-03 (6行目) | ○ |
| C-10 | @url設定（PATCH先） | E-03 (9行目) | ○ |
| C-11 | フォームパーシャル使用 | E-03 (10行目) | ○ |
| C-12 | trustedパラメータが追加許可 | E-01 (75-77行目) | ○ |
| C-13 | キャンセルボタンで一覧へ遷移 | E-04 (35行目) | ○ |
| C-14 | ページタイトル「Edit application」 | E-03 (8行目) | ○ |
| C-15 | パンくずリストに現在のアプリ名表示 | E-03 (2行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張に根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] Web IDE OAuthアプリ編集時の警告表示確認
- [ ] 更新成功時のリダイレクト先確認
- [ ] スコープ変更が正しく保存されるか確認
- [ ] バリデーションエラー時の表示確認
