---
generated_at: 2026-01-22 12:30:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：247-不正利用レポート一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/admin/abuse_reports_controller.rb` - コントローラ実装
- E-02: `app/models/abuse_report.rb` - モデル定義
- E-03: `app/finders/abuse_reports_finder.rb` - ファインダー実装
- E-04: `app/views/admin/abuse_reports/index.html.haml` - 一覧画面ビュー
- E-05: `app/helpers/admin/abuse_reports_helper.rb` - ヘルパー
- E-06: `config/routes/admin.rb` - ルーティング定義
- E-07: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧
- E-08: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面URL `/admin/abuse_reports` | E-06 (43行目) | ○ |
| C-02 | デフォルトステータスはopen | E-01 (48-49行目) | ○ |
| C-03 | AbuseReportsFinderでレポート取得 | E-01 (10行目) | ○ |
| C-04 | カテゴリenum定義（spam, offensive等） | E-02 (79-88行目) | ○ |
| C-05 | ステータスenum定義（open, closed） | E-02 (90-93行目) | ○ |
| C-06 | aggregated_by_user_and_categoryで集約 | E-02 (265-281行目), E-03 (91-96行目) | ○ |
| C-07 | filter_by_status実装 | E-03 (37-45行目) | ○ |
| C-08 | filter_by_category実装 | E-03 (47-51行目) | ○ |
| C-09 | filter_by_user実装 | E-03 (53-60行目) | ○ |
| C-10 | filter_by_reporter実装 | E-03 (62-69行目) | ○ |
| C-11 | ソート機能実装 | E-03 (71-85行目) | ○ |
| C-12 | Vue.jsコンポーネント使用 | E-04 (5行目) | ○ |
| C-13 | abuse_reports_list_dataヘルパー | E-05 (5-17行目) | ○ |
| C-14 | ページタイトル「Abuse reports」 | E-04 (1行目) | ○ |
| C-15 | before_action :set_status_param | E-01 (6行目) | ○ |
| C-16 | ページネーション実装 | E-03 (24行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張に根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] Vue.jsコンポーネントが正しくレンダリングされるか確認
- [ ] 集約表示（Open時）が正しく動作するか確認
- [ ] 各種フィルタリングが正しく動作するか確認
- [ ] ページネーションが正しく動作するか確認
