---
generated_at: 2026-01-22 12:20:00
metrics:
  claims_total: 24
  claims_with_evidence: 22
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：25-プロジェクト新規作成

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：22 / 24、根拠なし：2
- 優先レビュー（高）
  1. **テンプレート選択の詳細動作**：テンプレートパーシャルの確認が必要
  2. **Projects::CreateServiceの詳細処理**：サービスクラスの確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `app/views/projects/new.html.haml`
- E-02: `app/controllers/projects_controller.rb`
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | newアクションの処理 | E-02 (93-106行目) | ○ |
| C-02 | namespace_idからの名前空間取得 | E-02 (94行目) | ○ |
| C-03 | create_projects権限チェック | E-02 (95行目) | ○ |
| C-04 | AcceptingProjectCreationsFinderの使用 | E-02 (99行目) | ○ |
| C-05 | Projectオブジェクト初期化 | E-02 (105行目) | ○ |
| C-06 | createアクションの処理 | E-02 (114-125行目) | ○ |
| C-07 | Projects::CreateServiceの呼び出し | E-02 (115行目) | ○ |
| C-08 | 成功時のリダイレクト | E-02 (118-121行目) | ○ |
| C-09 | 失敗時のnew再レンダリング | E-02 (123行目) | ○ |
| C-10 | new_project_creation_formフィーチャーフラグ | E-01 (8行目) | ○ |
| C-11 | Vue.js版のdata属性設定 | E-01 (9-48行目) | ○ |
| C-12 | namespace_full_path設定 | E-01 (10行目) | ○ |
| C-13 | user_namespace_id設定 | E-01 (12行目) | ○ |
| C-14 | new_project_guidelines設定 | E-01 (14行目) | ○ |
| C-15 | push_to_create_project_command設定 | E-01 (15行目) | ○ |
| C-16 | support_sha256_repositoriesフラグ | E-01 (27行目) | ○ |
| C-17 | restricted_visibility_levels設定 | E-01 (28行目) | ○ |
| C-18 | インポートソース設定（GitHub等） | E-01 (31-47行目) | ○ |
| C-19 | 従来版のタブパネル構成 | E-01 (67-91行目) | ○ |
| C-20 | feature_category :groups_and_projects | E-02 (69行目) | ○ |
| C-21 | 関連機能No.1（プロジェクト作成） | E-03 (37-38行目) | ○ |
| C-22 | カテゴリ「プロジェクト」 | E-04 (26行目) | ○ |
| C-23 | テンプレート選択の詳細動作 | **根拠なし** | △ |
| C-24 | Projects::CreateServiceの詳細処理 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- テンプレート選択パーシャルの詳細実装
  - 候補：`app/views/projects/_project_templates.html.haml`
- Projects::CreateServiceの詳細実装
  - 候補：`app/services/projects/create_service.rb`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コントローラの基本処理、権限チェック
- 0: 低リスク - フィーチャーフラグによるUI切り替え
- 1: 中リスク - プロジェクト作成サービスの詳細動作

## 6) レビュアーチェックリスト（最小）
- [ ] Projects::CreateServiceの処理フローを確認
- [ ] テンプレートからの作成動作を確認
- [ ] インポートソースの有効/無効判定を確認
- [ ] バリデーションエラー時のエラーメッセージ表示を確認
- [ ] フィーチャーフラグの影響範囲を確認
