---
generated_at: 2026-01-22 12:45:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：250-ブロードキャストメッセージ一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/admin/broadcast_messages_controller.rb` - コントローラ実装
- E-02: `app/models/system/broadcast_message.rb` - モデル定義
- E-03: `app/helpers/admin/broadcast_messages_helper.rb` - ヘルパー実装
- E-04: `app/views/admin/broadcast_messages/index.html.haml` - 一覧画面ビュー
- E-05: `app/views/admin/broadcast_messages/edit.html.haml` - 編集画面ビュー
- E-06: `config/routes/admin.rb` - ルーティング定義
- E-07: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧
- E-08: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面URL `/admin/broadcast_messages` | E-06 (106-108行目) | ○ |
| C-02 | before_action :find_broadcast_messages | E-01 (8行目) | ○ |
| C-03 | indexアクションで新規インスタンス作成 | E-01 (14行目) | ○ |
| C-04 | createアクションでJSON/HTML対応 | E-01 (23-38行目) | ○ |
| C-05 | updateアクションでJSON/HTML対応 | E-01 (44-58行目) | ○ |
| C-06 | destroyアクション | E-01 (62-68行目) | ○ |
| C-07 | previewアクション | E-01 (71-73行目) | ○ |
| C-08 | ALLOWED_TARGET_ACCESS_LEVELS定義 | E-02 (8-15行目) | ○ |
| C-09 | enum :theme定義 | E-02 (42-53行目) | ○ |
| C-10 | enum :broadcast_type定義 | E-02 (55-58行目) | ○ |
| C-11 | flush_redis_cacheコールバック | E-02 (40行目, 160-163行目) | ○ |
| C-12 | 2週間キャッシュ | E-02 (89-91行目) | ○ |
| C-13 | Vue.jsコンポーネント使用 | E-04 (7行目) | ○ |
| C-14 | admin_broadcast_messages_dataヘルパー | E-03 (66-84行目) | ○ |
| C-15 | broadcast_message_dataヘルパー | E-03 (86-102行目) | ○ |
| C-16 | target_access_level_optionsヘルパー | E-03 (54-58行目) | ○ |
| C-17 | ページタイトル「Broadcast Messages」 | E-04 (2行目) | ○ |
| C-18 | ページ説明文 | E-04 (3行目) | ○ |
| C-19 | broadcast_message_params定義 | E-01 (86-98行目) | ○ |
| C-20 | default color/font | E-02 (29-30行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張に根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] Vue.jsコンポーネントが正しくレンダリングされるか確認
- [ ] メッセージ作成がJSON/HTML両方で動作するか確認
- [ ] プレビュー機能が正しく動作するか確認
- [ ] キャッシュフラッシュが正しく行われるか確認
- [ ] ターゲットパス（ワイルドカード）の動作確認
