---
generated_at: 2026-01-22 10:30:00
metrics:
  claims_total: 25
  claims_with_evidence: 23
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：251-ブロードキャストメッセージ編集

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：23 / 25、根拠なし：2
- 優先レビュー（高）
  1. **フロントエンドVue.jsコンポーネントの詳細仕様**：根拠不足
  2. **プレビュー機能の詳細実装**：根拠不足
  3. **N/A**：-

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/controllers/admin/broadcast_messages_controller.rb`
- E-02: `app/models/system/broadcast_message.rb`
- E-03: `app/views/admin/broadcast_messages/edit.html.haml`
- E-04: `app/helpers/admin/broadcast_messages_helper.rb`
- E-05: `config/routes/admin.rb`（106-108行目）
- E-06: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-07: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面URLは /admin/broadcast_messages/:id/edit | E-05 | ○ |
| C-02 | editアクションが存在する | E-01（17行目） | ○ |
| C-03 | updateアクションでJSON/HTML両形式対応 | E-01（41-59行目） | ○ |
| C-04 | before_actionでfind_broadcast_message実行 | E-01（7行目） | ○ |
| C-05 | broadcast_message_paramsで許可パラメータ定義 | E-01（86-98行目） | ○ |
| C-06 | theme enumに10種類の値が定義 | E-02（42-53行目） | ○ |
| C-07 | broadcast_type enumにbanner/notification | E-02（55-58行目） | ○ |
| C-08 | ALLOWED_TARGET_ACCESS_LEVELS定数存在 | E-02（8-15行目） | ○ |
| C-09 | message, starts_at, ends_at, broadcast_typeが必須 | E-02（19-22行目） | ○ |
| C-10 | flush_redis_cacheがafter_commitで実行 | E-02（40行目） | ○ |
| C-11 | 3種類のキャッシュキーが定義 | E-02（36-38行目） | ○ |
| C-12 | cache_markdown_fieldでmessageをキャッシュ | E-02（17行目） | ○ |
| C-13 | broadcast_message_dataヘルパー存在 | E-04（86-102行目） | ○ |
| C-14 | target_access_level_optionsヘルパー存在 | E-04（54-58行目） | ○ |
| C-15 | 編集画面はjs-broadcast-messageをマウント | E-03（6行目） | ○ |
| C-16 | パンくずリストでMessages追加 | E-03（1行目） | ○ |
| C-17 | 画面No.251はブロードキャストメッセージ編集 | E-06 | ○ |
| C-18 | 機能No.118と関連 | E-07 | ○ |
| C-19 | 更新成功時のフラッシュメッセージ | E-01（54行目） | ○ |
| C-20 | show_in_cliパラメータ対応 | E-01（97行目）, E-02（24行目） | ○ |
| C-21 | dismissableパラメータ対応 | E-01（96行目） | ○ |
| C-22 | previewアクション存在 | E-01（71-74行目）, E-05（107行目） | ○ |
| C-23 | 管理者のみアクセス可能 | E-01（Admin::名前空間） | ○ |
| C-24 | Vue.jsコンポーネントの詳細実装 | **根拠なし** | △ |
| C-25 | プレビューエリアの具体的UI仕様 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- Vue.jsフロントエンドコンポーネントのソースコードは未確認
  - 候補：`app/assets/javascripts/admin/broadcast_messages/` / `ee/app/assets/javascripts/`
- プレビュー機能のフロントエンド実装詳細
  - 候補：JavaScriptファイル内のプレビューロジック

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ルーティング、コントローラー、モデルの主要機能は根拠あり
- 1: 中リスク - フロントエンド詳細仕様は未確認だが、基本機能に影響なし

## 6) レビュアーチェックリスト（最小）
- [ ] Vue.jsコンポーネント（js-broadcast-message）の実装確認
- [ ] プレビュー機能のユーザビリティ確認
- [ ] target_access_levelsの選択UI確認
- [ ] 各テーマ色の表示確認
