---
generated_at: 2026-01-22 10:35:00
metrics:
  claims_total: 22
  claims_with_evidence: 21
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：252-Webhook一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：21 / 22、根拠なし：1
- 優先レビュー（高）
  1. **HookActionsモジュールの詳細実装**：根拠不足
  2. **N/A**：-
  3. **N/A**：-

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/controllers/admin/hooks_controller.rb`
- E-02: `app/models/hooks/system_hook.rb`
- E-03: `app/views/admin/hooks/index.html.haml`
- E-04: `app/views/admin/hooks/_form.html.haml`
- E-05: `app/views/shared/web_hooks/_index.html.haml`
- E-06: `config/routes/admin.rb`（94-104行目）
- E-07: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-08: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面URLは /admin/hooks | E-06 | ○ |
| C-02 | WebHooks::HookActionsをinclude | E-01（4行目） | ○ |
| C-03 | GitLab.comでは非表示 | E-01（8行目, 36-38行目） | ○ |
| C-04 | testアクションでTestHooks::SystemService呼び出し | E-01（10-11行目） | ○ |
| C-05 | relationメソッドでSystemHook返却 | E-01（20-22行目） | ○ |
| C-06 | AVAILABLE_HOOKSで4種類のフック定義 | E-02（7-12行目） | ○ |
| C-07 | push_eventsデフォルトfalse | E-02（24行目） | ○ |
| C-08 | repository_update_eventsデフォルトtrue | E-02（25行目） | ○ |
| C-09 | merge_requests_eventsデフォルトfalse | E-02（26行目） | ○ |
| C-10 | organization_id必須バリデーション | E-02（31行目） | ○ |
| C-11 | allow_local_requests?メソッド存在 | E-02（34-36行目） | ○ |
| C-12 | pluralized_nameでラベル取得 | E-02（38-40行目） | ○ |
| C-13 | SettingsSectionComponentでレイアウト | E-03（3行目） | ○ |
| C-14 | shared/web_hooks/indexパーシャル使用 | E-03（7行目） | ○ |
| C-15 | shared/file_hooks/indexパーシャル使用 | E-03（9行目） | ○ |
| C-16 | フォームにname, description, url, token項目 | E-04（4-16行目） | ○ |
| C-17 | トリガーイベント選択UI | E-04（18-32行目） | ○ |
| C-18 | SSL検証チェックボックス | E-04（34-36行目） | ○ |
| C-19 | CrudComponentで一覧表示 | E-05（1-5行目） | ○ |
| C-20 | 画面No.252はWebhook一覧 | E-07 | ○ |
| C-21 | 機能No.94と関連 | E-08 | ○ |
| C-22 | HookActionsの詳細実装（CRUD操作） | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- WebHooks::HookActions concernの詳細実装は未確認
  - 候補：`app/controllers/concerns/web_hooks/hook_actions.rb`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コントローラー、モデル、ビューの主要機能は根拠あり
- 0: 低リスク - ルーティング定義は確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] HookActions concernの実装確認（CRUD操作の詳細）
- [ ] テスト機能の動作確認
- [ ] ローカルアドレス許可設定の確認
- [ ] GitLab.com環境での非表示確認
