---
generated_at: 2026-01-22 10:40:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：253-Webhook編集

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **Hook Logs一覧パーシャルの詳細**：根拠不足
  2. **N/A**：-
  3. **N/A**：-

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/admin/hooks_controller.rb`
- E-02: `app/views/admin/hooks/edit.html.haml`
- E-03: `app/views/admin/hooks/_form.html.haml`
- E-04: `app/models/hooks/system_hook.rb`
- E-05: `config/routes/admin.rb`（94-104行目）
- E-06: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-07: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面URLは /admin/hooks/:id/edit | E-05 | ○ |
| C-02 | パンくずリストでSystem hooks追加 | E-02（1行目） | ○ |
| C-03 | ページタイトルはEdit system hook | E-02（2行目） | ○ |
| C-04 | hook_errorsパーシャルでエラー表示 | E-02（4行目） | ○ |
| C-05 | SettingsSectionComponentでレイアウト | E-02（6行目） | ○ |
| C-06 | フォームでadmin_hook_pathにPUT | E-02（10行目） | ○ |
| C-07 | _formパーシャルでフォーム内容表示 | E-02（11行目） | ○ |
| C-08 | Save changesボタン | E-02（15行目） | ○ |
| C-09 | test_buttonパーシャルでテストボタン | E-02（16行目） | ○ |
| C-10 | Closeボタンで一覧画面へ遷移 | E-02（18行目） | ○ |
| C-11 | Deleteボタンに確認ダイアログ | E-02（19行目） | ○ |
| C-12 | hook_logs/_indexでログ一覧表示 | E-02（23行目） | ○ |
| C-13 | testアクションでTestHooks::SystemService呼び出し | E-01（10-11行目） | ○ |
| C-14 | hook_param_namesでurl, token, name等許可 | E-01（28-30行目） | ○ |
| C-15 | フォームにname, description項目 | E-03（4-8行目） | ○ |
| C-16 | フォームにurl, token項目 | E-03（9-16行目） | ○ |
| C-17 | トリガーイベントチェックボックス | E-03（18-32行目） | ○ |
| C-18 | SSL検証チェックボックス | E-03（34-36行目） | ○ |
| C-19 | 画面No.253はWebhook編集 | E-06 | ○ |
| C-20 | hook_logsパーシャルの詳細実装 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- shared/hook_logs/_indexパーシャルの詳細実装は未確認
  - 候補：`app/views/shared/hook_logs/_index.html.haml`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 編集画面の主要機能は根拠あり
- 0: 低リスク - ルーティングとアクションボタンは確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] Hook Logsパーシャルの表示内容確認
- [ ] テスト機能の動作確認
- [ ] 削除確認ダイアログの動作確認
- [ ] トークンのマスク表示確認
