---
generated_at: 2026-01-22 10:50:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：255-デプロイキー一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **Vue.jsコンポーネントの詳細実装**：根拠不足
  2. **N/A**：-
  3. **N/A**：-

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/admin/deploy_keys_controller.rb`
- E-02: `app/views/admin/deploy_keys/index.html.haml`
- E-03: `app/helpers/admin/deploy_key_helper.rb`
- E-04: `app/models/deploy_key.rb`
- E-05: `config/routes/admin.rb`（92行目）
- E-06: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-07: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面URLは /admin/deploy_keys | E-05 | ○ |
| C-02 | ページタイトルは"Deploy keys" | E-02（1行目） | ○ |
| C-03 | PageHeadingComponentで見出し表示 | E-02（3行目） | ○ |
| C-04 | Vue.jsコンポーネントマウントポイント | E-02（5行目） | ○ |
| C-05 | admin_deploy_keys_dataヘルパー使用 | E-02（5行目） | ○ |
| C-06 | edit_path, delete_path, create_path提供 | E-03（6-9行目） | ○ |
| C-07 | empty_state_svg_path提供 | E-03（10行目） | ○ |
| C-08 | before_actionでdeploy_keys取得 | E-01（4行目） | ○ |
| C-09 | DeployKey.are_publicスコープ使用 | E-01（53-55行目） | ○ |
| C-10 | destroyアクションでHTML/JSON対応 | E-01（38-45行目） | ○ |
| C-11 | are_publicスコープ定義 | E-04（24行目） | ○ |
| C-12 | has_many :deploy_keys_projects | E-04（11行目） | ○ |
| C-13 | dependent: :destroy設定 | E-04（11行目） | ○ |
| C-14 | 画面No.255はデプロイキー一覧 | E-06 | ○ |
| C-15 | 機能No.119と関連 | E-07 | ○ |
| C-16 | Vue.jsコンポーネントの詳細実装 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- Vue.jsフロントエンドコンポーネントのソースコードは未確認
  - 候補：`app/assets/javascripts/admin/deploy_keys/`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - バックエンド機能は根拠あり
- 1: 中リスク - フロントエンド詳細仕様は未確認だが基本機能に影響なし

## 6) レビュアーチェックリスト（最小）
- [ ] Vue.jsコンポーネント（#js-admin-deploy-keys-table）の実装確認
- [ ] テーブルカラムの表示内容確認
- [ ] 削除確認ダイアログの動作確認
- [ ] 空状態表示の確認
