---
generated_at: 2026-01-22 10:55:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：256-デプロイキー新規作成

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **CreateServiceの詳細実装**：根拠不足
  2. **N/A**：-
  3. **N/A**：-

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/admin/deploy_keys_controller.rb`
- E-02: `app/views/admin/deploy_keys/new.html.haml`
- E-03: `app/views/shared/deploy_keys/_form.html.haml`
- E-04: `app/models/deploy_key.rb`
- E-05: `config/routes/admin.rb`（92行目）
- E-06: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-07: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面URLは /admin/deploy_keys/new | E-05 | ○ |
| C-02 | パンくずリストでDeploy keys追加 | E-02（1行目） | ○ |
| C-03 | ページタイトルは"New deploy key" | E-02（2行目） | ○ |
| C-04 | PageHeadingComponentで見出し表示 | E-02（4行目） | ○ |
| C-05 | gitlab_ui_form_forでフォーム生成 | E-02（6行目） | ○ |
| C-06 | _formパーシャルでフォーム内容表示 | E-02（7行目） | ○ |
| C-07 | Createボタン | E-02（9行目） | ○ |
| C-08 | Cancelボタンで一覧画面へ | E-02（10-11行目） | ○ |
| C-09 | タイトル入力フィールド | E-03（7-9行目） | ○ |
| C-10 | 公開鍵入力（新規作成時のみ） | E-03（11-19行目） | ○ |
| C-11 | 有効期限入力（datepicker） | E-03（21-23行目） | ○ |
| C-12 | newアクションでdeploy_keys.new | E-01（12-14行目） | ○ |
| C-13 | createアクションでCreateService使用 | E-01（16-18行目） | ○ |
| C-14 | public: trueをパラメータに追加 | E-01（18行目） | ○ |
| C-15 | create_paramsでkey, title, expires_at許可 | E-01（57-59行目） | ○ |
| C-16 | 画面No.256はデプロイキー新規作成 | E-06 | ○ |
| C-17 | 機能No.119と関連 | E-07 | ○ |
| C-18 | CreateServiceの詳細実装 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- DeployKeys::CreateServiceのソースコードは未確認
  - 候補：`app/services/deploy_keys/create_service.rb`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コントローラーとビューは根拠あり
- 1: 中リスク - サービス層の詳細は未確認だが基本機能に影響なし

## 6) レビュアーチェックリスト（最小）
- [ ] CreateServiceの実装確認
- [ ] SSH鍵フォーマット検証の確認
- [ ] フィンガープリント計算の確認
- [ ] 有効期限バリデーションの確認
