---
generated_at: 2026-01-22 11:00:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：257-デプロイキー編集

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  1. **なし** - すべての主張に根拠あり
  2. **N/A**：-
  3. **N/A**：-

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/admin/deploy_keys_controller.rb`
- E-02: `app/views/admin/deploy_keys/edit.html.haml`
- E-03: `app/views/shared/deploy_keys/_form.html.haml`
- E-04: `app/models/deploy_key.rb`
- E-05: `config/routes/admin.rb`（92行目）
- E-06: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-07: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面URLは /admin/deploy_keys/:id/edit | E-05 | ○ |
| C-02 | パンくずリストでDeploy keys追加 | E-02（1行目） | ○ |
| C-03 | ページタイトルは"Edit deploy key" | E-02（2行目） | ○ |
| C-04 | PageHeadingComponentで見出し表示 | E-02（4行目） | ○ |
| C-05 | gitlab_ui_form_forでフォーム生成 | E-02（6行目） | ○ |
| C-06 | _formパーシャルでフォーム内容表示 | E-02（7行目） | ○ |
| C-07 | Save changesボタン | E-02（9行目） | ○ |
| C-08 | Cancelボタンで一覧画面へ | E-02（10-11行目） | ○ |
| C-09 | タイトル入力フィールド（権限で読み取り専用制御） | E-03（7-9行目） | ○ |
| C-10 | フィンガープリントSHA256表示（読み取り専用） | E-03（25-28行目） | ○ |
| C-11 | フィンガープリントMD5表示（読み取り専用） | E-03（29-32行目） | ○ |
| C-12 | 有効期限表示（読み取り専用） | E-03（33-36行目） | ○ |
| C-13 | before_actionでdeploy_key取得 | E-01（5行目） | ○ |
| C-14 | update_paramsでtitleのみ許可 | E-01（61-63行目） | ○ |
| C-15 | 更新成功時にフラッシュメッセージ | E-01（31行目） | ○ |
| C-16 | 画面No.257はデプロイキー編集 | E-06 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - すべての主張に根拠あり

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての機能が根拠付きで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] タイトル編集の動作確認
- [ ] フィンガープリント表示の確認
- [ ] 読み取り専用フィールドの確認
- [ ] 権限（update_deploy_key_title）の確認
