---
generated_at: 2026-01-22 11:05:00
metrics:
  claims_total: 20
  claims_with_evidence: 18
  claims_without_evidence: 2
confidence_derived: 0.90
---

# 根拠レポート：258-Runner一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：18 / 20、根拠なし：2
- 優先レビュー（高）
  1. **Vue.jsコンポーネントの詳細実装**：根拠不足
  2. **GraphQL APIの詳細仕様**：根拠不足
  3. **N/A**：-

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/admin/runners_controller.rb`
- E-02: `app/views/admin/runners/index.html.haml`
- E-03: `app/helpers/ci/runners_helper.rb`
- E-04: `app/models/ci/runner.rb`
- E-05: `config/routes/admin.rb`（220-231行目）
- E-06: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-07: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面URLは /admin/runners | E-05 | ○ |
| C-02 | パンくずリストでRunners表示 | E-02（1行目） | ○ |
| C-03 | ページタイトルは"Runners" | E-02（2行目） | ○ |
| C-04 | イベントトラッキング設定 | E-02（4行目） | ○ |
| C-05 | Vue.jsコンポーネントマウントポイント | E-02（6行目） | ○ |
| C-06 | admin_runners_app_dataヘルパー使用 | E-02（6行目） | ○ |
| C-07 | runner_install_help_page提供 | E-03（75行目） | ○ |
| C-08 | new_runner_path提供 | E-03（76行目） | ○ |
| C-09 | allow_registration_token提供 | E-03（77行目） | ○ |
| C-10 | online_contact_timeout_secs提供 | E-03（79行目） | ○ |
| C-11 | stale_timeout_secs提供 | E-03（80行目） | ○ |
| C-12 | tag_suggestions_path提供 | E-03（81行目） | ○ |
| C-13 | can_admin_runners提供 | E-03（82行目, 89行目） | ○ |
| C-14 | ONLINE_CONTACT_TIMEOUTは2時間 | E-04（68行目） | ○ |
| C-15 | STALE_TIMEOUTは7日 | E-04（79行目） | ○ |
| C-16 | runner_typeにinstance/group/project | E-04（43-47行目） | ○ |
| C-17 | tag_listアクション存在 | E-01（41-44行目）, E-05（228行目） | ○ |
| C-18 | 画面No.258はRunner一覧 | E-06 | ○ |
| C-19 | Vue.jsコンポーネントの詳細実装 | **根拠なし** | △ |
| C-20 | GraphQL APIでRunner一覧取得 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- Vue.jsフロントエンドコンポーネントのソースコードは未確認
  - 候補：`app/assets/javascripts/ci/runner/admin_runners/`
- GraphQL APIの詳細仕様は未確認
  - 候補：`app/graphql/types/ci/runner_type.rb`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - バックエンド機能は根拠あり
- 1: 中リスク - フロントエンド詳細仕様は未確認だが基本機能に影響なし

## 6) レビュアーチェックリスト（最小）
- [ ] Vue.jsコンポーネント（#js-admin-runners）の実装確認
- [ ] GraphQL APIによるRunner取得の確認
- [ ] フィルタリング・検索機能の確認
- [ ] 一時停止/再開機能の確認
- [ ] 削除確認ダイアログの確認
