---
generated_at: 2026-01-22 11:10:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：259-Runner詳細

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **Vue.jsコンポーネントの詳細実装**：根拠不足
  2. **GraphQL APIの詳細仕様**：根拠不足
  3. **N/A**：-

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/admin/runners_controller.rb`
- E-02: `app/views/admin/runners/show.html.haml`
- E-03: `app/helpers/ci/runners_helper.rb`
- E-04: `app/models/ci/runner.rb`
- E-05: `config/routes/admin.rb`（220行目）
- E-06: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-07: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面URLは /admin/runners/:id | E-05 | ○ |
| C-02 | ci_statusスタイル追加 | E-02（1行目） | ○ |
| C-03 | runner_short_nameでタイトル生成 | E-02（3行目） | ○ |
| C-04 | パンくずリストでRunnersパス追加 | E-02（6行目） | ○ |
| C-05 | Vue.jsコンポーネントマウントポイント | E-02（8行目） | ○ |
| C-06 | runner_id, runners_path, edit_path提供 | E-02（8行目） | ○ |
| C-07 | showアクション存在 | E-01（18行目） | ○ |
| C-08 | before_actionでrunner取得 | E-01（8行目） | ○ |
| C-09 | Ci::Runner.findでrunner取得 | E-01（53-55行目） | ○ |
| C-10 | runner_short_nameメソッド存在 | E-03（54-56行目） | ○ |
| C-11 | runner_status_iconメソッド存在 | E-03（7-52行目） | ○ |
| C-12 | short_shaメソッド存在 | E-04（452-475行目） | ○ |
| C-13 | display_nameメソッド存在 | E-04（404-408行目） | ○ |
| C-14 | statusはCi::HasRunnerStatusモジュール | E-04（15行目） | ○ |
| C-15 | 画面No.259はRunner詳細 | E-06 | ○ |
| C-16 | 機能No.115と関連 | E-07 | ○ |
| C-17 | Vue.jsコンポーネントの詳細実装 | **根拠なし** | △ |
| C-18 | GraphQL APIでRunner詳細取得 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- Vue.jsフロントエンドコンポーネントのソースコードは未確認
  - 候補：`app/assets/javascripts/ci/runner/admin_runner_show/`
- GraphQL APIの詳細仕様は未確認
  - 候補：`app/graphql/types/ci/runner_type.rb`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - バックエンド機能は根拠あり
- 1: 中リスク - フロントエンド詳細仕様は未確認だが基本機能に影響なし

## 6) レビュアーチェックリスト（最小）
- [ ] Vue.jsコンポーネント（#js-admin-runner-show）の実装確認
- [ ] GraphQL APIによるRunner詳細取得の確認
- [ ] ステータスアイコン表示の確認
- [ ] Runner Manager情報の表示確認
- [ ] 編集・削除機能の確認
