---
generated_at: 2026-01-22 12:25:00
metrics:
  claims_total: 28
  claims_with_evidence: 26
  claims_without_evidence: 2
confidence_derived: 0.93
---

# 根拠レポート：26-プロジェクト編集

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：26 / 28、根拠なし：2
- 優先レビュー（高）
  1. **Vue.jsコンポーネントの詳細**：プロジェクト権限フォームの確認が必要
  2. **Projects::UpdateServiceの詳細処理**：サービスクラスの確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `app/views/projects/edit.html.haml`
- E-02: `app/controllers/projects_controller.rb`
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | editアクションの処理 | E-02 (109-112行目) | ○ |
| C-02 | badge_api_endpoint設定 | E-02 (110行目) | ○ |
| C-03 | updateアクションの処理 | E-02 (127-134行目) | ○ |
| C-04 | Projects::UpdateServiceの呼び出し | E-02 (128行目) | ○ |
| C-05 | housekeepingアクションの処理 | E-02 (264-291行目) | ○ |
| C-06 | HousekeepingService呼び出し | E-02 (271行目) | ○ |
| C-07 | 監査イベント記録 | E-02 (272-278行目) | ○ |
| C-08 | exportアクションの処理 | E-02 (293-305行目) | ○ |
| C-09 | archive/unarchiveアクションの処理 | E-02 (248-262行目) | ○ |
| C-10 | destroyアクションの処理 | E-02 (201-221行目) | ○ |
| C-11 | MarkForDeletionService呼び出し | E-02 (212行目) | ○ |
| C-12 | transferアクションの処理 | E-02 (137-149行目) | ○ |
| C-13 | TransferService呼び出し | E-02 (141行目) | ○ |
| C-14 | SettingsBlockComponentの使用 | E-01 (13行目, 22行目等) | ○ |
| C-15 | 基本情報セクションの構成 | E-01 (13-20行目) | ○ |
| C-16 | 可視性・機能権限セクションの構成 | E-01 (22-32行目) | ○ |
| C-17 | reduce-visibility-form-idの設定 | E-01 (4行目, 29行目) | ○ |
| C-18 | project_permissions_form_dataの設定 | E-01 (31行目) | ○ |
| C-19 | バッジセクションの構成 | E-01 (34-42行目) | ○ |
| C-20 | GitLab Duoセクション（条件付き） | E-01 (44-54行目) | ○ |
| C-21 | 詳細設定セクションの構成 | E-01 (60-119行目) | ○ |
| C-22 | ハウスキーピングボタン | E-01 (78-80行目) | ○ |
| C-23 | エクスポートセクション | E-01 (82行目) | ○ |
| C-24 | パス変更セクション | E-01 (86-112行目) | ○ |
| C-25 | 関連機能No.2,3,4,5 | E-03 (39-42行目) | ○ |
| C-26 | カテゴリ「プロジェクト」 | E-04 (27行目) | ○ |
| C-27 | Vue.jsプロジェクト権限フォームの詳細 | **根拠なし** | △ |
| C-28 | Projects::UpdateServiceの詳細処理 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- Vue.jsプロジェクト権限フォームコンポーネント
  - 候補：`app/assets/javascripts/pages/projects/edit/` / `app/assets/javascripts/projects/settings/`
- Projects::UpdateServiceの詳細実装
  - 候補：`app/services/projects/update_service.rb`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コントローラの基本処理、ルーティング
- 0: 低リスク - 各セクションの構成
- 1: 中リスク - 権限フォームのVue.jsコンポーネント実装

## 6) レビュアーチェックリスト（最小）
- [ ] Projects::UpdateServiceの処理フローを確認
- [ ] 可視性変更時の確認モーダル動作を確認
- [ ] Vue.jsプロジェクト権限フォームの動作を確認
- [ ] ハウスキーピングのLeaseTakenエラー処理を確認
- [ ] エクスポート制限の動作を確認
