---
generated_at: 2026-01-22 11:15:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：260-Runner新規登録

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **Vue.jsコンポーネントの詳細実装**：根拠不足
  2. **GraphQL Mutationの詳細仕様**：根拠不足
  3. **N/A**：-

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/admin/runners_controller.rb`
- E-02: `app/views/admin/runners/new.html.haml`
- E-03: `app/models/ci/runner.rb`
- E-04: `config/routes/admin.rb`（220-231行目）
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面URLは /admin/runners/new | E-04（220行目） | ○ |
| C-02 | パンくずリストでRunnersパス追加 | E-02（1行目） | ○ |
| C-03 | パンくずタイトルは"Create" | E-02（2行目） | ○ |
| C-04 | ページタイトルは"Create an instance runner" | E-02（3行目） | ○ |
| C-05 | Vue.jsコンポーネントマウントポイント | E-02（5行目） | ○ |
| C-06 | runners_path提供 | E-02（5行目） | ○ |
| C-07 | newアクション存在 | E-01（24行目） | ○ |
| C-08 | runner_create_wizard_adminフィーチャーフラグpush | E-01（9-11行目） | ○ |
| C-09 | registerアクション存在 | E-01（26-28行目）, E-04（222行目） | ○ |
| C-10 | CREATED_RUNNER_TOKEN_PREFIX定数 | E-03（60行目） | ○ |
| C-11 | REGISTRATION_AVAILABILITY_TIME定数 | E-03（82行目） | ○ |
| C-12 | registration_type enum存在 | E-03（54-57行目） | ○ |
| C-13 | creation_state enum存在 | E-03（49-52行目） | ○ |
| C-14 | registration_available?メソッド存在 | E-03（571-575行目） | ○ |
| C-15 | 画面No.260はRunner新規登録 | E-05 | ○ |
| C-16 | 機能No.115と関連 | E-06 | ○ |
| C-17 | Vue.jsコンポーネントの詳細実装 | **根拠なし** | △ |
| C-18 | GraphQL Mutationの詳細仕様 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- Vue.jsフロントエンドコンポーネントのソースコードは未確認
  - 候補：`app/assets/javascripts/ci/runner/admin_new_runner/`
- GraphQL Mutationの詳細仕様は未確認
  - 候補：`app/graphql/mutations/ci/runner/create.rb`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - バックエンド機能は根拠あり
- 1: 中リスク - フロントエンド詳細仕様は未確認だが基本機能に影響なし

## 6) レビュアーチェックリスト（最小）
- [ ] Vue.jsコンポーネント（#js-admin-new-runner）の実装確認
- [ ] GraphQL Mutationによる作成処理の確認
- [ ] トークン生成の確認（プレフィックス付き）
- [ ] 登録画面への遷移確認
- [ ] フィーチャーフラグの影響確認
