---
generated_at: 2026-01-22 10:30:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：261-Runner編集

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **Vueコンポーネントの実装詳細**：フロントエンドコードの確認が必要
  2. **Gitlab.comでの追加フィールド**：EE版コードの確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/views/admin/runners/edit.html.haml`（行1-44）
- E-02: `app/controllers/admin/runners_controller.rb`（行1-85）
- E-03: `app/models/ci/runner.rb`（行1-100）
- E-04: `config/routes/admin.rb`（行220-231）
- E-05: `app/views/admin/runners/_project.html.haml`（行1-24）
- E-06: `docs/code-to-docs/画面一覧/画面一覧.csv`（行262）
- E-07: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（行318）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面URLは`/admin/runners/:id/edit` | E-04 | ○ |
| C-02 | コントローラーは`Admin::RunnersController` | E-02 | ○ |
| C-03 | editアクションで`assign_projects`メソッドを呼び出す | E-02（行20-22） | ○ |
| C-04 | updateアクションで`UpdateRunnerService`を使用 | E-02（行31） | ○ |
| C-05 | プロジェクト検索は`Project.search`を使用 | E-02（行72-73） | ○ |
| C-06 | 1ページ30件のページネーション | E-02（行80） | ○ |
| C-07 | FORM_EDITABLE定数で編集可能属性を定義 | E-03（行91） | ○ |
| C-08 | プロジェクトタイプRunnerのみ割り当てセクション表示 | E-01（行9） | ○ |
| C-09 | js-admin-runner-editがVueマウントポイント | E-01（行7） | ○ |
| C-10 | 割り当て解除はオーナー以外のみ可能 | E-01（行22-24） | ○ |
| C-11 | プロジェクトパーシャルでアバターを表示 | E-05（行13） | ○ |
| C-12 | オーナーバッジを表示 | E-05（行17-18） | ○ |
| C-13 | 機能No.115ランナー管理が主機能 | E-07 | ○ |
| C-14 | 管理者権限が必要 | E-02（Admin::ApplicationController継承） | ○ |
| C-15 | runner_projectsテーブルで割り当て管理 | E-03（行99） | ○ |
| C-16 | access_levelはenumで定義 | E-03（行38-41） | ○ |
| C-17 | Vueコンポーネントの実装詳細 | **根拠なし** | △ |
| C-18 | Gitlab.comでMINUTES_COST_FACTOR_FIELDSも編集可能 | E-02（行62-66）、E-03（行92） | ○ |

## 4) 不足情報（Unknown / Missing）
- Vueコンポーネント（`js-admin-runner-edit`）の実装詳細
  - 候補：`app/assets/javascripts/ci/runner/admin_runner_edit/` / `ee/app/assets/javascripts/`
- EE版での追加機能の詳細
  - 候補：`ee/app/controllers/ee/admin/runners_controller.rb`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - データベース更新仕様（コードから直接確認可能）
- 1: 中リスク - フロントエンド実装詳細（Vue.jsコードの確認推奨）
- 0: 低リスク - ルーティング設定（明確に定義されている）

## 6) レビュアーチェックリスト（最小）
- [ ] `app/assets/javascripts/ci/runner/`以下のVueコンポーネントを確認
- [ ] EE版での追加フィールドを確認（Gitlab.com環境向け）
- [ ] UpdateRunnerServiceの完全な実装を確認
- [ ] runner_projectsコントローラーの存在を確認（割り当て操作用）
