---
generated_at: 2026-01-22 10:35:00
metrics:
  claims_total: 15
  claims_with_evidence: 13
  claims_without_evidence: 2
confidence_derived: 0.87
---

# 根拠レポート：262-ジョブ一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.87**
  - 根拠あり：13 / 15、根拠なし：2
- 優先レビュー（高）
  1. **GraphQL APIの詳細実装**：フロントエンドのデータ取得部分
  2. **表示項目の完全性**：Vueコンポーネントの確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/views/admin/jobs/index.html.haml`（行1-8）
- E-02: `app/controllers/admin/jobs_controller.rb`（行1-23）
- E-03: `app/helpers/admin/jobs_helper.rb`（行1-15）
- E-04: `config/routes/admin.rb`（行233-237）
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv`（行263）
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（行319）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面URLは`/admin/jobs` | E-04 | ○ |
| C-02 | コントローラーは`Admin::JobsController` | E-02 | ○ |
| C-03 | indexアクションは空（Vueに委譲） | E-02（行13） | ○ |
| C-04 | cancel_allで全ジョブをキャンセル | E-02（行15-18） | ○ |
| C-05 | Ci::Build.running_or_pendingを使用 | E-02（行16） | ○ |
| C-06 | BUILDS_PER_PAGEは30 | E-02（行4） | ○ |
| C-07 | admin_jobs_app_dataでVueデータを生成 | E-03 | ○ |
| C-08 | can_admin_all_resourcesで権限チェック | E-03（行10） | ○ |
| C-09 | #admin-jobs-appがVueマウントポイント | E-01（行7） | ○ |
| C-10 | ci_statusスタイルを使用 | E-01（行1） | ○ |
| C-11 | 機能No.116ジョブ管理が主機能 | E-06 | ○ |
| C-12 | admin_jobs_filter_runner_typeフィーチャーフラグ | E-02（行10） | ○ |
| C-13 | feature_categoryはcontinuous_integration | E-02（行6） | ○ |
| C-14 | GraphQL APIでデータ取得 | **根拠なし** | △ |
| C-15 | 表示項目（ステータス、ジョブID等）の詳細 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- VueコンポーネントとGraphQLクエリの実装詳細
  - 候補：`app/assets/javascripts/ci/admin/jobs_table/` / `app/graphql/`
- 表示項目のカラム定義
  - 候補：Vueコンポーネント内のテーブル定義

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コントローラーとルーティング（明確に定義）
- 1: 中リスク - フロントエンド実装（Vue.js/GraphQLの確認推奨）
- 0: 低リスク - キャンセル処理（シンプルな実装）

## 6) レビュアーチェックリスト（最小）
- [ ] `app/assets/javascripts/ci/admin/jobs_table/`以下のVueコンポーネントを確認
- [ ] GraphQLスキーマ/クエリの確認
- [ ] Ci::Buildモデルのcancel/running_or_pendingメソッドの確認
- [ ] 空状態SVGのパスを確認（`empty-pipeline-md.svg`）
