---
generated_at: 2026-01-22 10:40:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：263-偽装トークン一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **スコープ一覧の完全性**：Gitlab::Authの実装確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/views/admin/impersonation_tokens/index.html.haml`（行1-35）
- E-02: `app/controllers/admin/impersonation_tokens_controller.rb`（行1-91）
- E-03: `config/routes/admin.rb`（行7-12）
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`（行264）
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（行320）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面URLは`/admin/users/:user_id/impersonation_tokens` | E-03 | ○ |
| C-02 | コントローラーは`Admin::ImpersonationTokensController` | E-02 | ○ |
| C-03 | indexアクションでset_index_varsを呼び出す | E-02（行9-13） | ○ |
| C-04 | createはAjaxでJSON返却 | E-02（行15-26） | ○ |
| C-05 | revokeでトークンを無効化 | E-02（行28-39） | ○ |
| C-06 | rotateでRotateServiceを使用 | E-02（行41-53） | ○ |
| C-07 | keep_token_lifetime: trueで有効期限維持 | E-02（行43） | ○ |
| C-08 | verify_impersonation_enabled!で機能チェック | E-02（行63-65） | ○ |
| C-09 | PersonalAccessTokensFinderでトークン検索 | E-02（行67-73） | ○ |
| C-10 | impersonation: trueで偽装トークンを識別 | E-02（行70） | ○ |
| C-11 | ImpersonationAccessTokenSerializerでJSON化 | E-02（行77） | ○ |
| C-12 | organization_idを設定 | E-02（行17, 71） | ○ |
| C-13 | #js-new-access-token-appがVueマウントポイント | E-01（行9） | ○ |
| C-14 | CrudComponentでUI構成 | E-01（行11-34） | ○ |
| C-15 | 機能No.81個人アクセストークンが主機能 | E-05 | ○ |
| C-16 | 「Revoked impersonation token」メッセージ | E-02（行32） | ○ |
| C-17 | User.find_by!(username:)でユーザー取得 | E-02（行59） | ○ |
| C-18 | Gitlab::Auth.available_scopes_forでスコープ取得 | E-02（行85） | ○ |
| C-19 | feature_categoryはuser_management | E-02（行7） | ○ |
| C-20 | スコープ選択肢の詳細一覧 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 利用可能なスコープの完全な一覧
  - 候補：`lib/gitlab/auth.rb` / `AVAILABLE_SCOPES`定数

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - CRUD操作（明確にコード化されている）
- 0: 低リスク - 権限チェック（before_actionで実装）
- 1: 中リスク - スコープ一覧（動的に取得されるため要確認）

## 6) レビュアーチェックリスト（最小）
- [ ] `lib/gitlab/auth.rb`の`available_scopes_for`メソッドを確認
- [ ] `PersonalAccessToken`モデルのバリデーションを確認
- [ ] `RotateService`の完全な実装を確認
- [ ] 偽装機能の有効化設定（ApplicationSetting）を確認
