---
generated_at: 2026-01-22 10:45:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：264-ラベル一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠があり、優先レビュー項目なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/views/admin/labels/index.html.haml`（行1-30）
- E-02: `app/controllers/admin/labels_controller.rb`（行1-68）
- E-03: `app/models/label.rb`（行1-100）
- E-04: `config/routes/admin.rb`（行218）
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv`（行265）
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（行321）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面URLは`/admin/labels` | E-04 | ○ |
| C-02 | コントローラーは`Admin::LabelsController` | E-02 | ○ |
| C-03 | indexでテンプレートラベルを取得 | E-02（行10） | ○ |
| C-04 | Label.in_organization.templatesを使用 | E-02（行10）、E-03（行42-43） | ○ |
| C-05 | ページネーションを適用 | E-02（行10） | ○ |
| C-06 | destroyでラベルを削除 | E-02（行41-57） | ○ |
| C-07 | 削除成功メッセージを表示 | E-02（行45-46） | ○ |
| C-08 | CrudComponentで一覧表示 | E-01（行10） | ○ |
| C-09 | 空状態コンポーネントを表示 | E-01（行22-29） | ○ |
| C-10 | page_bundles/labelsスタイルを使用 | E-01（行2） | ○ |
| C-11 | イベントトラッキング view_admin_labels_pageload | E-01（行7） | ○ |
| C-12 | 機能No.120ラベル管理が主機能 | E-06 | ○ |
| C-13 | feature_categoryはteam_planning | E-02（行6） | ○ |
| C-14 | set_labelでラベルを取得（before_action） | E-02（行4, 61-63） | ○ |
| C-15 | 説明文 "Labels created here will be automatically added to new projects." | E-01（行3） | ○ |
| C-16 | 新規作成ボタンで/admin/labels/newに遷移 | E-01（行14-15） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全ての主張に根拠が確認された）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての実装が明確にコード化されている

## 6) レビュアーチェックリスト（最小）
- [ ] `templates`スコープの定義を確認（label.rb行42）
- [ ] `in_organization`スコープの定義を確認（label.rb行43）
- [ ] ラベルパーシャル `_label.html.haml` の存在を確認
- [ ] CASCADE DELETE の動作を確認（dependent: :destroy）
