---
generated_at: 2026-01-22 11:00:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：267-コホート分析

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠があり、優先レビュー項目なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/views/admin/cohorts/index.html.haml`（行1-17）
- E-02: `app/controllers/admin/cohorts_controller.rb`（行1-38）
- E-03: `app/services/cohorts_service.rb`（行1-101）
- E-04: `app/views/admin/cohorts/_cohorts_table.html.haml`（行1-33）
- E-05: `config/routes/admin.rb`（行145）
- E-06: `docs/code-to-docs/画面一覧/画面一覧.csv`（行268）
- E-07: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（行324）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面URLは`/admin/cohorts` | E-05 | ○ |
| C-02 | コントローラーは`Admin::CohortsController` | E-02 | ○ |
| C-03 | indexでload_cohortsを呼び出す | E-02（行16-17） | ○ |
| C-04 | Rails.cacheで1日間キャッシュ | E-02（行23） | ○ |
| C-05 | CohortsService.new.executeを使用 | E-02（行24） | ○ |
| C-06 | CohortsSerializerでシリアライズ | E-02（行27） | ○ |
| C-07 | MONTHS_INCLUDEDは12 | E-03（行4） | ○ |
| C-08 | DATE_TRUNCで月単位に集計 | E-03（行98） | ○ |
| C-09 | running_totalsでリテンション計算 | E-03（行56-68） | ○ |
| C-10 | counts_by_monthでSQLクエリ | E-03（行82-94） | ○ |
| C-11 | ProductAnalyticsTrackingでイベント送信 | E-02（行4, 10-14） | ○ |
| C-12 | i_analytics_cohortsイベント名 | E-02（行11） | ○ |
| C-13 | feature_categoryはdevops_reports | E-02（行6） | ○ |
| C-14 | "New users"と"Returning users"のヘッダー | E-04（行8-10） | ○ |
| C-15 | 機能No.126リポジトリアナリティクスが主機能 | E-07 | ○ |
| C-16 | 新規ユーザー作成ボタン | E-01（行9-10） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全ての主張に根拠が確認された）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての実装が明確にコード化されている

## 6) レビュアーチェックリスト（最小）
- [ ] `CohortsSerializer`の出力形式を確認
- [ ] `last_activity_on`のNULL処理を確認
- [ ] キャッシュキー `cohorts` の一意性を確認
- [ ] Redis HLLとSnowplowへのイベント送信設定を確認
