---
generated_at: 2026-01-22 11:05:00
metrics:
  claims_total: 14
  claims_with_evidence: 12
  claims_without_evidence: 2
confidence_derived: 0.86
---

# 根拠レポート：268-使用トレンド

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.86**
  - 根拠あり：12 / 14、根拠なし：2
- 優先レビュー（高）
  1. **GraphQL APIの詳細実装**：Vueコンポーネントのデータ取得部分
  2. **Chart.jsの使用確認**：グラフ描画実装の確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/views/admin/usage_trends/index.html.haml`（行1-7）
- E-02: `app/controllers/admin/usage_trends_controller.rb`（行1-26）
- E-03: `config/routes/admin.rb`（行142）
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`（行269）
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（行325）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面URLは`/admin/usage_trends` | E-03 | ○ |
| C-02 | コントローラーは`Admin::UsageTrendsController` | E-02 | ○ |
| C-03 | indexアクションは空（Vueに委譲） | E-02（行16） | ○ |
| C-04 | #js-usage-trends-appがVueマウントポイント | E-01（行6） | ○ |
| C-05 | ProductAnalyticsTrackingでイベント送信 | E-02（行4, 6-10） | ○ |
| C-06 | i_analytics_instance_statisticsイベント名 | E-02（行7） | ○ |
| C-07 | feature_categoryはdevops_reports | E-02（行12） | ○ |
| C-08 | view_admin_usage_trends_pageloadイベント | E-01（行4） | ○ |
| C-09 | 機能No.126リポジトリアナリティクスが主機能 | E-05 | ○ |
| C-10 | urgencyはlow | E-02（行14） | ○ |
| C-11 | ページタイトル"Usage trends" | E-01（行2） | ○ |
| C-12 | パンくず"Usage trends" | E-01（行1） | ○ |
| C-13 | GraphQL APIでデータ取得 | **根拠なし** | △ |
| C-14 | Chart.jsでグラフ描画 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- VueコンポーネントとGraphQLクエリの実装詳細
  - 候補：`app/assets/javascripts/analytics/usage_trends/`
- グラフ描画ライブラリの使用確認
  - 候補：`app/assets/javascripts/vue_shared/components/`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コントローラーとルーティング（明確に定義）
- 1: 中リスク - フロントエンド実装（Vue.js/GraphQLの確認推奨）
- 1: 中リスク - データモデル（UsageTrendsMeasurementの確認推奨）

## 6) レビュアーチェックリスト（最小）
- [ ] `app/assets/javascripts/analytics/usage_trends/`以下のVueコンポーネントを確認
- [ ] GraphQLスキーマ/クエリの確認（usageTrendsMeasurements）
- [ ] `Analytics::UsageTrendsMeasurement`モデルの存在と構造を確認
- [ ] グラフ描画ライブラリの特定
