---
generated_at: 2026-01-22 11:10:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：269-DevOpsレポート

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **DevOpsスコアカテゴリの完全性**：Metricモデルの確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/views/admin/dev_ops_report/show.html.haml`（行1-9）
- E-02: `app/controllers/admin/dev_ops_report_controller.rb`（行1-41）
- E-03: `app/views/admin/dev_ops_report/_score.html.haml`（行1-7）
- E-04: `config/routes/admin.rb`（行143-144）
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv`（行270）
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（行326）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面URLは`/admin/dev_ops_reports` | E-04 | ○ |
| C-02 | 旧URL`/admin/dev_ops_report`からリダイレクト | E-04（行144） | ○ |
| C-03 | コントローラーは`Admin::DevOpsReportController` | E-02 | ○ |
| C-04 | showアクションでメトリクス取得 | E-02（行18-20） | ○ |
| C-05 | DevOpsReport::Metric.order(:created_at).lastを使用 | E-02（行19） | ○ |
| C-06 | &.presentでPresenter化 | E-02（行19） | ○ |
| C-07 | show_adoption?でEE版タブ判定 | E-02（行23-25） | ○ |
| C-08 | should_track_devops_score?でイベント条件判定 | E-02（行27-29） | ○ |
| C-09 | track_internal_eventでイベント送信 | E-02（行8-11） | ○ |
| C-10 | i_analytics_dev_ops_scoreイベント名 | E-02（行9） | ○ |
| C-11 | feature_categoryはdevops_reports | E-02（行13） | ○ |
| C-12 | service_ping_enabledで表示分岐 | E-03（行1-6） | ○ |
| C-13 | page_bundles/dev_ops_reportsスタイル使用 | E-01（行2） | ○ |
| C-14 | view_admin_dev_ops_reports_pageloadイベント | E-01（行4） | ○ |
| C-15 | 機能No.127 CI/CDアナリティクスが主機能 | E-06 | ○ |
| C-16 | DevOpsスコアカテゴリの詳細 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- DevOpsスコアカテゴリの完全な一覧
  - 候補：`app/models/dev_ops_report/metric.rb`
- EE版のDevOps Adoptionタブの実装
  - 候補：`ee/app/views/admin/dev_ops_report/`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コントローラーとルーティング（明確に定義）
- 1: 中リスク - スコアカテゴリの詳細（Metricモデルの確認推奨）
- 0: 低リスク - 表示分岐（service_ping_enabledで明確に制御）

## 6) レビュアーチェックリスト（最小）
- [ ] `DevOpsReport::Metric`モデルの構造を確認
- [ ] `devops_score_metrics`ヘルパーの実装を確認
- [ ] EE版の`render_if_exists 'admin/dev_ops_report/devops_tabs'`の存在を確認
- [ ] サービスPing無効時のVueコンポーネント（`js-devops-service-ping-disabled`）を確認
