---
generated_at: 2026-01-22 12:30:00
metrics:
  claims_total: 20
  claims_with_evidence: 18
  claims_without_evidence: 2
confidence_derived: 0.90
---

# 根拠レポート：27-プロジェクトフォーク

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：18 / 20、根拠なし：2
- 優先レビュー（高）
  1. **Vue.jsフォークフォームの詳細**：フロントエンドコンポーネントの確認が必要
  2. **Projects::ForkServiceの詳細処理**：サービスクラスの確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `app/views/projects/forks/new.html.haml`
- E-02: `app/controllers/projects/forks_controller.rb`
- E-03: `config/routes/project.rb`
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | newアクションの処理（HTML） | E-02 (43-66行目) | ○ |
| C-02 | newアクションの処理（JSON） | E-02 (50-63行目) | ○ |
| C-03 | can_fork_to?による確認 | E-02 (46行目, 92-94行目) | ○ |
| C-04 | load_namespaces_with_associations | E-02 (138-144行目) | ○ |
| C-05 | ForkNamespaceSerializerの使用 | E-02 (56-60行目) | ○ |
| C-06 | createアクションの処理 | E-02 (68-88行目) | ○ |
| C-07 | 既存フォークの確認 | E-02 (69-70行目) | ○ |
| C-08 | fork_serviceの呼び出し | E-02 (73行目) | ○ |
| C-09 | authorize_fork_namespace! | E-02 (15行目, 130-132行目) | ○ |
| C-10 | エラー時のrender :error | E-02 (79行目) | ○ |
| C-11 | 成功時のリダイレクト | E-02 (81-87行目) | ○ |
| C-12 | fork_serviceメソッド | E-02 (108-112行目) | ○ |
| C-13 | ビューのdata属性設定 | E-01 (3-15行目) | ○ |
| C-14 | fork_illustrationパス | E-01 (3行目) | ○ |
| C-15 | restricted_visibility_levels | E-01 (15行目) | ○ |
| C-16 | URL /forks/new | E-03 (256行目) | ○ |
| C-17 | 関連機能No.7（プロジェクトフォーク） | E-04 (43行目) | ○ |
| C-18 | カテゴリ「プロジェクト」 | E-05 (28行目) | ○ |
| C-19 | Vue.jsフォークフォームの詳細 | **根拠なし** | △ |
| C-20 | Projects::ForkServiceの詳細処理 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- Vue.jsフォークフォームコンポーネント
  - 候補：`app/assets/javascripts/pages/projects/forks/new/` / `app/assets/javascripts/vue_shared/components/`
- Projects::ForkServiceの詳細実装
  - 候補：`app/services/projects/fork_service.rb`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コントローラの基本処理、ルーティング
- 0: 低リスク - 権限チェック
- 1: 中リスク - フォークサービスの詳細動作

## 6) レビュアーチェックリスト（最小）
- [ ] Projects::ForkServiceの処理フローを確認
- [ ] Vue.jsフォークフォームの動作を確認
- [ ] 可視性制限の適用ロジックを確認
- [ ] 既存フォークがある場合の動作を確認
- [ ] バックグラウンドフォークの動作を確認
