---
generated_at: 2026-01-22 11:15:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：270-Gitalyサーバー一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠があり、優先レビュー項目なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/views/admin/gitaly_servers/index.html.haml`（行1-36）
- E-02: `app/controllers/admin/gitaly_servers_controller.rb`（行1-11）
- E-03: `lib/gitaly/server.rb`（行1-141）
- E-04: `config/routes/admin.rb`（行48）
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv`（行271）
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（行327）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面URLは`/admin/gitaly_servers` | E-04 | ○ |
| C-02 | コントローラーは`Admin::GitalyServersController` | E-02 | ○ |
| C-03 | authorize! :read_admin_gitaly_serversで権限チェック | E-02（行5） | ○ |
| C-04 | indexでGitaly::Server.allを呼び出す | E-02（行8） | ○ |
| C-05 | Server.allで全ストレージ取得 | E-03（行11-12） | ○ |
| C-06 | storage属性でストレージ名取得 | E-03（行28）、E-01（行23） | ○ |
| C-07 | address属性でアドレス取得 | E-03（行85-88）、E-01（行25） | ○ |
| C-08 | server_version属性でバージョン取得 | E-03（行34-36）、E-01（行27） | ○ |
| C-09 | git_binary_version属性でGitバージョン取得 | E-03（行38-40）、E-01（行29） | ○ |
| C-10 | up_to_date?で最新判定 | E-03（行42-45）、E-01（行31） | ○ |
| C-11 | expected_server_versionと比較 | E-03（行43） | ○ |
| C-12 | SHA_VERSION_REGEXでSHA形式対応 | E-03（行5, 105-110） | ○ |
| C-13 | GRPC::Unavailable例外処理 | E-03（行134） | ○ |
| C-14 | GRPC::DeadlineExceeded例外処理 | E-03（行134） | ○ |
| C-15 | feature_categoryはgitaly | E-02（行4） | ○ |
| C-16 | 接続失敗時のエラーメッセージ | E-01（行35） | ○ |
| C-17 | view_admin_gitaly_servers_pageloadイベント | E-01（行4） | ○ |
| C-18 | 機能No.143ヘルスチェックが主機能 | E-06 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全ての主張に根拠が確認された）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての実装が明確にコード化されている

## 6) レビュアーチェックリスト（最小）
- [ ] `gitlab.yml`の`repositories.storages`設定を確認
- [ ] `Gitlab::GitalyClient::ServerService`の完全な実装を確認
- [ ] `Gitlab::GitalyClient.expected_server_version`の取得元を確認
- [ ] `Gitlab::ErrorTracking.track_exception`によるエラー記録を確認
