---
generated_at: 2026-01-22 10:30:00
metrics:
  claims_total: 25
  claims_with_evidence: 24
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：271-外見設定

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：24 / 25、根拠なし：1
- 優先レビュー（高）
  1. **C-25**: _system_header_footer_form.html.haml の内容未確認

## 2) 参照した情報（Evidence一覧）

- E-01: `app/views/admin/application_settings/appearances/show.html.haml`（7行）
- E-02: `app/views/admin/application_settings/appearances/_form.html.haml`（146行）
- E-03: `app/controllers/admin/application_settings/appearances_controller.rb`（102行）
- E-04: `app/models/appearance.rb`（128行）
- E-05: `config/routes/admin.rb`（204行目付近）
- E-06: `docs/code-to-docs/画面一覧/画面一覧.csv`（272行目）
- E-07: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（328行目）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面名は「外見設定」である | E-06 | ○ |
| C-02 | テンプレートファイルはshow.html.hamlである | E-01 | ○ |
| C-03 | 機能No.114「アプリケーション設定」に関連 | E-07 | ○ |
| C-04 | 管理者権限が必要 | E-03（3行目: Admin::ApplicationController継承） | ○ |
| C-05 | URLは/admin/application_settings/appearances | E-05 | ○ |
| C-06 | faviconの最大サイズは1MB | E-04（53行目） | ○ |
| C-07 | pwa_nameの最大文字数は255 | E-04（31-36行目） | ○ |
| C-08 | pwa_short_nameの最大文字数は255 | E-04（38-43行目） | ○ |
| C-09 | pwa_descriptionの最大文字数は2048 | E-04（45-50行目） | ○ |
| C-10 | profile_image_guidelinesの最大文字数は4096 | E-04（57行目） | ○ |
| C-11 | message_background_colorのデフォルトは#E75E40 | E-04（20行目） | ○ |
| C-12 | message_font_colorのデフォルトは#FFFFFF | E-04（21行目） | ○ |
| C-13 | appearancesテーブルは1レコードのみ許可 | E-04（71-73行目） | ○ |
| C-14 | 成功メッセージ「Appearance was successfully created.」 | E-03（19行目） | ○ |
| C-15 | 成功メッセージ「Appearance was successfully updated.」 | E-03（27行目） | ○ |
| C-16 | 成功メッセージ「Logo was successfully removed.」 | E-03（38行目） | ○ |
| C-17 | 成功メッセージ「Header logo was successfully removed.」 | E-03（45行目） | ○ |
| C-18 | 成功メッセージ「Favicon was successfully removed.」 | E-03（61行目） | ○ |
| C-19 | PWAアイコン削除成功メッセージあり | E-03（53-54行目） | ○ |
| C-20 | cache_markdown_fieldでdescriptionをキャッシュ | E-04（24行目） | ○ |
| C-21 | cache_markdown_fieldでmember_guidelinesをキャッシュ | E-04（25行目） | ○ |
| C-22 | CarrierWaveでlogo, header_logo, pwa_icon, faviconを管理 | E-04（61-64行目） | ○ |
| C-23 | フォームにファビコン設定セクションあり | E-02（6-23行目） | ○ |
| C-24 | プレビューボタンでサインインページを表示 | E-02（134-135行目） | ○ |
| C-25 | システムヘッダー/フッター設定のフォームパーシャルあり | E-02（126行目の参照のみ） | △ |

## 4) 不足情報（Unknown / Missing）

- **_system_header_footer_form.html.haml の詳細未確認**
  - _form.html.hamlの126行目で参照されているが、ファイル内容を直接確認していない
  - 候補：`app/views/admin/application_settings/appearances/_system_header_footer_form.html.haml`

## 5) リスクフラグ（レビュー観点）

- **0: 低リスク** - 主要な処理フローとデータモデルはソースコードから確認済み
- 画面設計書の内容は高い信頼性を持つ

## 6) レビュアーチェックリスト（最小）

- [ ] システムヘッダー/フッター設定の詳細が正しいか確認
- [ ] 実際の画面でファビコンサイズ32x32pxの制約が表示されるか確認
- [ ] email_header_and_footer_enabled の実際の動作確認
