---
generated_at: 2026-01-22 10:35:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：272-バックグラウンドマイグレーション一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `app/views/admin/background_migrations/index.html.haml`（44行）
- E-02: `app/controllers/admin/background_migrations_controller.rb`（74行）
- E-03: `lib/gitlab/database/background_migration/batched_migration.rb`（368行）
- E-04: `lib/gitlab/database/background_migration/batched_job.rb`（284行）
- E-05: `config/routes/admin.rb`（112-120行目）
- E-06: `docs/code-to-docs/画面一覧/画面一覧.csv`（273行目）
- E-07: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（329行目）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面名は「バックグラウンドマイグレーション一覧」である | E-06 | ○ |
| C-02 | テンプレートファイルはindex.html.hamlである | E-01 | ○ |
| C-03 | 機能No.117「バックグラウンドジョブ監視」に関連 | E-07 | ○ |
| C-04 | URLは/admin/background_migrations | E-05（112行目） | ○ |
| C-05 | タブはQueued/Finalizing/Failed/Finishedの4つ | E-01（13-24行目） | ○ |
| C-06 | 権限チェックはread_admin_background_migrations | E-02（9行目） | ○ |
| C-07 | Pauseアクションでpause!メソッドを実行 | E-02（32-35行目） | ○ |
| C-08 | Resumeアクションでexecute!メソッドを実行 | E-02（37-42行目） | ○ |
| C-09 | RetryアクションでstatusがfailedのときのみRetry実行 | E-02（46-47行目） | ○ |
| C-10 | state_machineでpausedは値0 | E-03（89行目） | ○ |
| C-11 | state_machineでactiveは値1 | E-03（90行目） | ○ |
| C-12 | state_machineでfinishedは値3 | E-03（91行目） | ○ |
| C-13 | state_machineでfailedは値4 | E-03（92行目） | ○ |
| C-14 | state_machineでfinalizingは値5 | E-03（93行目） | ○ |
| C-15 | queuedスコープはactive, pausedステータス | E-03（36行目） | ○ |
| C-16 | finalizingスコープはfinalizing ステータス | E-03（37行目） | ○ |
| C-17 | successful_rows_countsでBatchedJob.sum(:batch_size) | E-03（156-162行目） | ○ |
| C-18 | 複数データベース対応でsupport_multiple_databases | E-02（8行目, 54-57行目） | ○ |
| C-19 | データベース切り替えはdatabasesパラメータで制御 | E-01（26行目）, E-02（61-63行目） | ○ |
| C-20 | before_transition any => :activeでstarted_at設定 | E-03（124-126行目） | ○ |
| C-21 | before_transition any => :finishedでfinished_at設定 | E-03（120-122行目） | ○ |
| C-22 | retry_failed_jobs!で失敗ジョブを分割してリトライ | E-03（197-206行目） | ○ |

## 4) 不足情報（Unknown / Missing）

- なし（主要な機能は全てソースコードから確認済み）

## 5) リスクフラグ（レビュー観点）

- **0: 低リスク** - 主要な処理フローとデータモデルはソースコードから完全に確認済み

## 6) レビュアーチェックリスト（最小）

- [ ] _migration.html.hamlパーシャルの詳細確認（各行の表示内容）
- [ ] 実際の画面でProgress計算が正しく表示されるか確認
- [ ] 複数データベース環境での動作確認
