---
generated_at: 2026-01-22 10:40:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：273-バックグラウンドマイグレーション詳細

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `app/views/admin/background_migrations/show.html.haml`（40行）
- E-02: `app/controllers/admin/background_migrations_controller.rb`（25-29行目）
- E-03: `lib/gitlab/database/background_migration/batched_migration.rb`
- E-04: `lib/gitlab/database/background_migration/batched_job.rb`
- E-05: `config/routes/admin.rb`（112行目）
- E-06: `docs/code-to-docs/画面一覧/画面一覧.csv`（274行目）
- E-07: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（330行目）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面名は「バックグラウンドマイグレーション詳細」である | E-06 | ○ |
| C-02 | テンプレートファイルはshow.html.hamlである | E-01 | ○ |
| C-03 | 機能No.117「バックグラウンドジョブ監視」に関連 | E-07 | ○ |
| C-04 | URLは/admin/background_migrations/:id | E-05 | ○ |
| C-05 | コントローラのshowアクションでマイグレーションを取得 | E-02（26行目） | ○ |
| C-06 | 失敗ジョブはwith_status(:failed)でフィルタ | E-02（28行目） | ○ |
| C-07 | ページタイトルはジョブクラス名 : テーブル名 | E-01（6行目） | ○ |
| C-08 | 表示項目にId, Min Value, Max Valueがある | E-01（13-15行目） | ○ |
| C-09 | 表示項目にBatch size, Sub-batch sizeがある | E-01（16-17行目） | ○ |
| C-10 | 表示項目にInterval, Pause time (ms)がある | E-01（18-19行目） | ○ |
| C-11 | 表示項目にCreated on, Last updated, Statusがある | E-01（20-22行目） | ○ |
| C-12 | 失敗ジョブ一覧の表示は条件付き | E-01（26行目：if文） | ○ |
| C-13 | 失敗ジョブ一覧にはId, Started at, Finished at, Batch sizeがある | E-01（32-35行目） | ○ |
| C-14 | BatchedMigrationはhas_many :batched_jobsを持つ | E-03（20行目） | ○ |
| C-15 | ページネーションが適用される | E-02（28行目：.page）, E-01（39行目） | ○ |

## 4) 不足情報（Unknown / Missing）

- なし（主要な機能は全てソースコードから確認済み）

## 5) リスクフラグ（レビュー観点）

- **0: 低リスク** - 参照系画面のため更新処理なし、ソースコードから完全に確認済み

## 6) レビュアーチェックリスト（最小）

- [ ] _migration_full_information.html.hamlパーシャルの詳細確認
- [ ] _job.html.hamlパーシャルの詳細確認
- [ ] 実際の画面で全項目が正しく表示されるか確認
