---
generated_at: 2026-01-22 10:45:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：274-バッチジョブ詳細

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `app/views/admin/batched_jobs/show.html.haml`（37行）
- E-02: `app/controllers/admin/batched_jobs_controller.rb`（34行）
- E-03: `lib/gitlab/database/background_migration/batched_job.rb`
- E-04: `config/routes/admin.rb`（113行目）
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv`（275行目）
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（331行目）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面名は「バッチジョブ詳細」である | E-05 | ○ |
| C-02 | テンプレートファイルはshow.html.hamlである | E-01 | ○ |
| C-03 | 機能No.117「バックグラウンドジョブ監視」に関連 | E-06 | ○ |
| C-04 | URLは/admin/background_migrations/:id/batched_jobs/:id | E-04 | ○ |
| C-05 | コントローラのshowアクションでジョブを取得 | E-02（11行目） | ○ |
| C-06 | トランジションログを取得 | E-02（13行目） | ○ |
| C-07 | ページタイトルはBatched Job (Id: {id}) | E-01（7行目） | ○ |
| C-08 | 表示項目にId, Min Value, Max Valueがある | E-01（12-14行目） | ○ |
| C-09 | 表示項目にBatch size, Started at, Finished atがある | E-01（15-17行目） | ○ |
| C-10 | 表示項目にAttempts, Pause time (ms)がある | E-01（18-19行目） | ○ |
| C-11 | トランジションログ表示は条件付き | E-01（23行目：if文） | ○ |
| C-12 | トランジションログにId, Created At, Previous Status, Next Statusがある | E-01（29-32行目） | ○ |
| C-13 | トランジションログにException Class, Exception Messageがある | E-01（33-34行目） | ○ |
| C-14 | BatchedJobはhas_many :batched_job_transition_logsを持つ | E-03（29行目） | ○ |
| C-15 | MAX_ATTEMPTSは3 | E-03（18行目） | ○ |
| C-16 | after_transitionでトランジションログ作成 | E-03（91-96行目） | ○ |

## 4) 不足情報（Unknown / Missing）

- なし（主要な機能は全てソースコードから確認済み）

## 5) リスクフラグ（レビュー観点）

- **0: 低リスク** - 参照系画面のため更新処理なし、ソースコードから完全に確認済み

## 6) レビュアーチェックリスト（最小）

- [ ] _job.html.hamlパーシャルの詳細確認
- [ ] _transition_log.html.hamlパーシャルの詳細確認
- [ ] 実際の画面で例外情報が正しく表示されるか確認
