---
generated_at: 2026-01-22 10:55:00
metrics:
  claims_total: 22
  claims_with_evidence: 21
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：276-ログイン画面（管理者再認証）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：21 / 22、根拠なし：1
- 優先レビュー（高）
  1. **C-22**: CurrentUserModeクラスの詳細未確認

## 2) 参照した情報（Evidence一覧）

- E-01: `app/views/admin/sessions/new.html.haml`（19行）
- E-02: `app/controllers/admin/sessions_controller.rb`（83行）
- E-03: `config/routes/admin.rb`（35-37行目）
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`（277行目）
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（333行目）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面名は「ログイン画面」（管理者再認証）である | E-04 | ○ |
| C-02 | テンプレートファイルはnew.html.hamlである | E-01 | ○ |
| C-03 | 機能No.76「ユーザー登録」に関連 | E-05 | ○ |
| C-04 | URLは/admin/session/new、POST /admin/session | E-03 | ○ |
| C-05 | ページタイトルはEnter admin mode | E-01（1行目） | ○ |
| C-06 | user_is_admin!で管理者権限チェック | E-02（8行目, 47-49行目） | ○ |
| C-07 | 既に管理者モード有効の場合リダイレクト | E-02（13-14行目） | ○ |
| C-08 | request_admin_mode!で再認証要求 | E-02（16行目） | ○ |
| C-09 | two_factor_enabled_for_user?で2FAチェック | E-02（22行目, 51-53行目） | ○ |
| C-10 | enable_admin_mode!(password:)で有効化 | E-02（24行目） | ○ |
| C-11 | 成功メッセージはAdmin mode enabled | E-02（25行目） | ○ |
| C-12 | エラーメッセージはInvalid login or password | E-02（27行目） | ○ |
| C-13 | NotRequestedErrorでリダイレクト | E-02（30-32行目） | ○ |
| C-14 | destroyでdisable_admin_mode!を実行 | E-02（36行目） | ○ |
| C-15 | 無効化成功メッセージはAdmin mode disabled | E-02（42行目） | ○ |
| C-16 | LDAP認証サポート（any_form_based_providers_enabled?） | E-01（7行目） | ○ |
| C-17 | OmniAuth認証サポート（omniauth_enabled?） | E-01（17行目） | ○ |
| C-18 | 認証方法なしの場合メッセージ表示 | E-01（13-15行目） | ○ |
| C-19 | valid_otp_attempt?でOTP検証 | E-02（74-82行目） | ○ |
| C-20 | invalidate_otp_backup_code!でバックアップコード無効化 | E-02（81行目） | ○ |
| C-21 | step_up_auth_scope: 'admin_mode'でOAuth認証 | E-01（18行目） | ○ |
| C-22 | Gitlab::Auth::CurrentUserModeで状態管理 | E-02（参照のみ）、クラス未確認 | △ |

## 4) 不足情報（Unknown / Missing）

- **Gitlab::Auth::CurrentUserModeクラスの詳細未確認**
  - `lib/gitlab/auth/current_user_mode.rb`の内容を直接確認していない
  - セッションベースでの状態管理の詳細が未確認

## 5) リスクフラグ（レビュー観点）

- **1: 中リスク** - セキュリティに関連する管理者認証画面のため、認証フローを確認すべき

## 6) レビュアーチェックリスト（最小）

- [ ] Gitlab::Auth::CurrentUserModeクラスの実装確認
- [ ] LDAP認証時の管理者モード有効化フロー確認
- [ ] OmniAuth認証時のstep_up_auth動作確認
- [ ] 2FA有効時の認証フロー確認
- [ ] セキュリティ：リダイレクト先の検証が適切か確認
