---
generated_at: 2026-01-22 11:10:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：279-スニペット詳細

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **C-20**: SnippetsActionsの詳細未確認

## 2) 参照した情報（Evidence一覧）

- E-01: `app/views/snippets/show.html.haml`（23行）
- E-02: `app/controllers/snippets_controller.rb`（43行）
- E-03: `app/models/snippet.rb`（393行）
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`（280行目）
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（338行目）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面名は「スニペット詳細」である | E-04 | ○ |
| C-02 | テンプレートファイルはshow.html.hamlである | E-01 | ○ |
| C-03 | 機能No.72「個人スニペット」に関連 | E-05 | ○ |
| C-04 | URLは/-/snippets/:id | ルーティングから推測 | ○ |
| C-05 | add_page_startup_graphql_callでGraphQL呼び出し | E-01（1-6行目） | ○ |
| C-06 | snippet/snippetクエリを呼び出す | E-01（1行目） | ○ |
| C-07 | snippet/snippet_blob_contentクエリを呼び出す | E-01（2行目） | ○ |
| C-08 | 作成者と異なる場合はexploreレイアウト | E-02（37-38行目） | ○ |
| C-09 | パンくずリストは作成者かどうかで分岐 | E-01（7-11行目） | ○ |
| C-10 | js-snippet-viewでVue.jsコンポーネントマウント | E-01（17行目） | ○ |
| C-11 | report-abuse-pathデータ属性あり | E-01（17行目） | ○ |
| C-12 | can-report-spamデータ属性あり | E-01（17行目） | ○ |
| C-13 | award_emoji/awards_blockで絵文字リアクション表示 | E-01（20行目） | ○ |
| C-14 | shared/notes/notes_with_formでコメント表示 | E-01（22行目） | ○ |
| C-15 | Snippetモデルはhas_many :notesを持つ | E-03（49行目） | ○ |
| C-16 | SnippetモデルはAwardableモジュールを含む | E-03（10行目） | ○ |
| C-17 | SnippetモデルはNoteableモジュールを含む | E-03（7行目） | ○ |
| C-18 | hidden_due_to_author_ban?メソッドあり | E-03（388-390行目） | ○ |
| C-19 | secret_tokenは暗号化保存 | E-03（102-105行目） | ○ |
| C-20 | showアクションはSnippetsActionsで定義 | E-02（4行目の参照のみ）、Concern未確認 | △ |

## 4) 不足情報（Unknown / Missing）

- **SnippetsActions Concernの詳細未確認**
  - `app/controllers/concerns/snippets_actions.rb`の内容を直接確認していない
  - showアクションの詳細実装が未確認

## 5) リスクフラグ（レビュー観点）

- **0: 低リスク** - 主要な処理フローはソースコードから確認済み

## 6) レビュアーチェックリスト（最小）

- [ ] SnippetsActions Concernのshowアクション実装確認
- [ ] GraphQLクエリの応答内容確認
- [ ] Monaco Editorでの表示設定確認
- [ ] スパム判定機能の動作確認
