---
generated_at: 2026-01-22 12:35:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：28-フォーク一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **ForkProjectsFinderの詳細処理**：ファインダークラスの確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `app/views/projects/forks/index.html.haml`
- E-02: `app/controllers/projects/forks_controller.rb`
- E-03: `config/routes/project.rb`
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | indexアクションの処理 | E-02 (20-41行目) | ○ |
| C-02 | sortパラメータ取得 | E-02 (21行目) | ○ |
| C-03 | フォーク数カウント（総数） | E-02 (23行目) | ○ |
| C-04 | フォーク数カウント（公開） | E-02 (24行目) | ○ |
| C-05 | フォーク数カウント（非公開） | E-02 (25行目) | ○ |
| C-06 | フォーク数カウント（内部） | E-02 (26行目) | ○ |
| C-07 | load_forksの呼び出し | E-02 (28行目, 96-106行目) | ○ |
| C-08 | ForkProjectsFinderの使用 | E-02 (97-100行目) | ○ |
| C-09 | prepare_projects_for_rendering | E-02 (30行目) | ○ |
| C-10 | JSON形式のレスポンス | E-02 (35-38行目) | ○ |
| C-11 | ヘッダーとフォーク数表示 | E-01 (7-10行目) | ○ |
| C-12 | 検索フォーム | E-01 (13-15行目) | ○ |
| C-13 | ソートドロップダウン | E-01 (17-20行目) | ○ |
| C-14 | フォークボタン（条件付き） | E-01 (22-28行目) | ○ |
| C-15 | フォーク一覧パーシャル | E-01 (30行目) | ○ |
| C-16 | URL /-/forks | E-03 (256行目) | ○ |
| C-17 | 関連機能No.7（プロジェクトフォーク） | E-04 (44行目) | ○ |
| C-18 | ForkProjectsFinderの詳細処理 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- ForkProjectsFinderの詳細実装
  - 候補：`app/finders/fork_projects_finder.rb`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コントローラの基本処理、ルーティング
- 0: 低リスク - ビューの構造
- 0: 低リスク - フォーク数カウントロジック

## 6) レビュアーチェックリスト（最小）
- [ ] ForkProjectsFinderの検索ロジックを確認
- [ ] アクセス権限によるフィルタリングを確認
- [ ] ソート機能の動作を確認
- [ ] 既存フォークがある場合のボタン動作を確認
