---
generated_at: 2026-01-22 11:15:00
metrics:
  claims_total: 21
  claims_with_evidence: 20
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：280-スニペット新規作成

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：20 / 21、根拠なし：1
- 優先レビュー（高）
  1. **C-21**: Snippets::CreateServiceの詳細未確認

## 2) 参照した情報（Evidence一覧）

- E-01: `app/views/snippets/new.html.haml`（6行）
- E-02: `app/views/shared/snippets/_form.html.haml`（3行）
- E-03: `app/controllers/snippets_controller.rb`（43行）
- E-04: `app/models/snippet.rb`（393行）
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv`（281行目）
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（339行目）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面名は「スニペット新規作成」である | E-05 | ○ |
| C-02 | テンプレートファイルはnew.html.hamlである | E-01 | ○ |
| C-03 | 機能No.72「個人スニペット」に関連 | E-06 | ○ |
| C-04 | URLは/-/snippets/new | E-01（5行目のurl） | ○ |
| C-05 | ページタイトルはNew snippet | E-01（2行目） | ○ |
| C-06 | パンくずリストにdashboard_snippets_pathを設定 | E-01（1行目） | ○ |
| C-07 | shared/snippets/_formパーシャルを使用 | E-01（5行目） | ○ |
| C-08 | newアクションでPersonalSnippet.newを作成 | E-03（24行目） | ○ |
| C-09 | authorize_create_snippet!で権限チェック | E-03（11行目） | ○ |
| C-10 | MAX_FILE_COUNTは10 | E-04（25行目） | ○ |
| C-11 | DESCRIPTION_LENGTH_MAXは1MB | E-04（27行目） | ○ |
| C-12 | titleバリデーションで255文字制限 | E-04（60行目） | ○ |
| C-13 | file_nameバリデーションで255文字制限 | E-04（61-62行目） | ○ |
| C-14 | descriptionバリデーションでbytesizeチェック | E-04（63行目） | ○ |
| C-15 | contentは必須（presence: true） | E-04（65行目） | ○ |
| C-16 | contentにbytesize制限あり | E-04（66行目） | ○ |
| C-17 | デフォルト公開設定はdefault_snippet_visibility | E-04（218-226行目） | ○ |
| C-18 | check_for_spam?でスパムチェック判定 | E-04（289-291行目） | ○ |
| C-19 | supports_recaptcha?がtrueを返す | E-04（293-295行目） | ○ |
| C-20 | #js-snippet-editでVue.jsコンポーネントマウント | E-02（2行目） | ○ |
| C-21 | Snippets::CreateServiceで作成処理 | サービスクラス未確認 | △ |

## 4) 不足情報（Unknown / Missing）

- **Snippets::CreateServiceの詳細未確認**
  - `app/services/snippets/create_service.rb`の内容を直接確認していない
  - リポジトリ作成、ファイル追加の詳細処理が未確認

## 5) リスクフラグ（レビュー観点）

- **0: 低リスク** - 主要なバリデーションとフォーム構成はソースコードから確認済み

## 6) レビュアーチェックリスト（最小）

- [ ] Snippets::CreateServiceの実装確認
- [ ] Vue.jsコンポーネント（#js-snippet-edit）の詳細確認
- [ ] 複数ファイル追加のフロントエンド動作確認
- [ ] スパムチェック・reCAPTCHA動作確認
